map_projection_project(&_ref_pos,
				       _pos_sp_triplet.current.lat, _pos_sp_triplet.current.lon,
				       &curr_sp.data[0], &curr_sp.data[1]);
					   
输入参数：	&_ref_pos
				/* lat/lon are in radians */
				struct map_projection_reference_s {//地图投影参考
					double lat_rad;
					double lon_rad;
					double sin_lat;
					double cos_lat;
					bool init_done;
					uint64_t timestamp;
				};
				纬度是地心到某地连线与地心到赤道连线的夹角就是某地纬度，赤道为0度，两极是90度
				经度是英国伦敦附近的格林尼治天文台为0度，向东西两边逐加分别为东经和西经，到背面就是180度
				度数/360=弧度/2π
			_pos_sp_triplet.current.lat, _pos_sp_triplet.current.lon
				position_setpoint_s结构体中double lat;(纬度)double lon;(经度)，由navigator发布
			&curr_sp.data[0], &curr_sp.data[1]
				x,y方向位置		
实现的功能：将经纬度转换成地坐标系xy值				
{
	if (!map_projection_initialized(ref)) {
		return -1;
	}

	double lat_rad = lat * M_DEG_TO_RAD;//#define M_DEG_TO_RAD 	0.01745329251994角度转弧度
	double lon_rad = lon * M_DEG_TO_RAD;//#define M_RAD_TO_DEG 	57.2957795130823弧度转角度

	double sin_lat = sin(lat_rad);
	double cos_lat = cos(lat_rad);
	double cos_d_lon = cos(lon_rad - ref->lon_rad);
	//ref->lon_rad是copy ORB_ID(vehicle_local_position)主题，经过update_ref()里面的
	//map_projection_init(&_ref_pos, _local_pos.ref_lat, _local_pos.ref_lon);
	//ref->lon_rad = lon_0 * M_DEG_TO_RAD;

	double c = acos(ref->sin_lat * sin_lat + ref->cos_lat * cos_lat * cos_d_lon);
	double k = (fabs(c) < DBL_EPSILON) ? 1.0 : (c / sin(c));

	*x = k * (ref->cos_lat * sin_lat - ref->sin_lat * cos_lat * cos_d_lon) * CONSTANTS_RADIUS_OF_EARTH;
	*y = k * cos_lat * sin(lon_rad - ref->lon_rad) * CONSTANTS_RADIUS_OF_EARTH;
	//#define CONSTANTS_RADIUS_OF_EARTH(地球半径)			6371000			/* meters (m)		*/
	return 0;
}