<%
Class User 'Extends bbs--Common
	private tableName
	sub initialize
		tableName = "User"
		that.d("layuicachepage") = "user"
	end sub
	
	'用户管理 用户列表
	sub list
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
		dim obj,templatePath
		set obj = objCMS
		
		templatePath= obj.getTemplatePath( "user/list" )
		
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'用户管理 动态数据ajax
	sub search
		dim page,perpage

		
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
		
	
		
		dim rs,where,order,oPage,keyword,IsAdmin
			
		
		if that.get("IsAdmin") = 1 then
			IsAdmin = 1
		else
			IsAdmin = 0
		end if
		
	
		
		set where = D_
		order = "a.GroupID ASC,UserID desc"
		page = that.req("page")
		perpage = that.req("limit")
		
		'注意这儿的用法，不返回值，而是不断的添加条件
		B_(tableName).field("UserID,IsAdmin,LoginName,Gender,Email,QQ,LastLoginTime,UserStatus,a.GroupID,GroupName,Mobile,Address,RegTime,LastLoginIP,TrueName,Nickname,Experience,Avatar").from("{prefix}User as a, {prefix}UserGroup as b").page( array( page,perpage ) ).order(order)
		
		where("a.GroupID=b.GroupID") = null
		'where("{prefix}UserGroup.IsAdmin") = IsAdmin
		
		if that.req("ViewType") <> "" then
			where(that.req("ViewType")) = null
		end if
		
		if that.get("GroupID") <> "" then
			where("{prefix}User.GroupID") = that.get("GroupID")
		end if
		

	
		
		'下面才得到返回值
		if POP_MVC.req("keyword") <> "" then	
			set rs = B_(tableName).where(where).search( CStr( POP_MVC.req("keyword") ) , "LoginName,Nickname" )
		else
			set rs = B_(tableName).where(where).select
		end if
		

		Call that.LayuiTableAjax( rs, "" , 0 )
	end sub
	
	'用户管理 送积分
	sub IncExperience
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
		Call B_(tableName).where( that.form("id") ).setInc( Array("Experience" , that.form("Experience"))  )
		Call M_("bbs--Message").SendMessages( S_("adminId") , that.form("id") , S_("adminName") & "站长赠送您 " &  that.form("Experience") & " " & guestConfig.ExperienceName  )
		that.success("设置成功！")
	end sub
	
	'用户管理 减积分
	sub DecExperience
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
		Call B_(tableName).where( that.form("id") ).setDec( Array("Experience" , that.form("Experience"))  )
		Call M_("bbs--Message").SendMessages( S_("adminId") , that.form("id") , S_("adminName") & "站长惩罚您 " &  that.form("Experience") & " " & guestConfig.ExperienceName  )
		that.success("设置成功！")
	end sub
	
	'用户中心
	sub index
		dim obj,templatePath,UserID
		set obj = objCMS

		UserID = S_("adminId")
		
		set userRS = B_("User").where(UserID).find
		
		that.d("user") = B_("User").where(UserID).find		
		
		Call getSignData
		
		templatePath= obj.getTemplatePath( "user/index" )
		
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'获取签到
	private sub getSignData
		dim signRS
		
		'获取与分配签到数据
		that.d("IsSign") = false
		that.d("SignDays") = 0
		if S_("adminId") <> "" then			
			set signRS = B_("self_GuestDigg").where( "UserID = " & S_("adminId") ).field("UserID,SignTime,SignDays,SignExperience").find
			
			that.d("SignExperience") = K_("bbs--Experience").getNextSignExperience(signRS)
			
			if not signRS.eof then
				if  datediff( "d" , signRS("SignTime") , now() ) <=1 then
					that.d("IsSign") = true	
					that.d("SignDays") = signRS("SignDays")
					that.d("SignExperience") = signRS("SignExperience")
				end if
			end if
		end if
	end sub
	
	
	'我的帖子与收藏帖子
	sub thread
		dim obj,templatePath
		set obj = objCMS
		
		dim UserID,where,ids
		UserID = S_("adminId")
		
		'提问
		set where = D_
		
		where("ContentStatus") = 1
		where("UserID") = S_("adminId") 
		that.d("thread") = B_("self_GuestTopic").field("TopicID,Title,AddTime,Visits,ReplyCount,IsTop,IsFeatured").where( where ).top(30).page("null,30").order("TopicID DESC").select
		
		ids = B_("self_GuestConfig").from("{prefix}self_GuestDigg").field("Collection").where("UserID = " & UserID).getOne
		ids = POP_MVC.trim(ids,",")
		
		'收藏帖子
		set where = D_
		
		'where("UserID") = S_("adminId") 
		if not isNul(ids) then
			where("TopicID") = Array("In",ids)
		else
			where("1=2") = null
		end if
		that.d("collection") = B_("self_GuestTopic").field("TopicID,AddTime,Title,Visits,ReplyCount").where( where ).top(30).page("null,30").select
		
		templatePath= obj.getTemplatePath( "user/thread" )
		
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'消息列表
	sub Message
		dim rs,where,obj,templatePath,rs2,item,key,href
		set where = D_
		
		
		where("ToUser") = S_("adminId")
		where("IsRead") = 0
		set rs = B_("self_GuestConfig").field("a.UserID,a.NickName,a.Avatar,a.LoginName,b.AddTime,b.Message").from("{prefix}User as a").leftjoin("{prefix}self_GuestMessage as b on a.UserID = b.FromUser").where(where).order("MessageID desc").select
		where.remove("IsRead")
		set rs2 = B_("self_GuestConfig").field("a.Avatar as img,b.Message as info,a.UserID as href,a.LoginName,b.AddTime").from("{prefix}User as a").leftjoin("{prefix}self_GuestMessage as b on a.UserID = b.FromUser").top(15).where(where).order("MessageID desc").getAll
		
		for each key in rs2
			set item = rs2(key)
			href = item("href")
			if (inStr( item("info") , "回答了您的求解" ) > 0 or inStr( item("info") , "提到了您" ) >0) and inStr( item("info") , "<a " ) > 0 then
				item("href") = POP_MVC.String.getInStr(item("info") , "<a target='_blank' href='" , "'")
			else
				item("href") = getUserULink( href )
			end if

			item("info") = POP_MVC.String.cut( item("info"),30 )
			item("title") =  POP_MVC.dateStr(item("AddTime")) & " "  & item("info")
			item.remove("AddTime")
			item.remove("LoginName")
		next

		that.d("barrager") = rs2
		
		that.d("RecordCount") = rs2.count
		that.d("message") = rs
		
		if rs.RecordCount > 0 then
			set where = D_
			where("IsRead") = 0
			where("ToUser") = S_("adminId")
			Call B_("self_GuestMessage").where(where).setNot("IsRead")
		end if

		set obj = objCMS
		templatePath= obj.getTemplatePath( "user/message" )
		obj.load(templatePath)	
		obj.parseHtml
		obj.output	
	end sub	
	
	'发送消息
	sub sendMessage
		dim dict,id
		if not M_("bbs--Message").db.create(1) then
			that.error( M_("bbs--Message").db.error )
		end if
		
		id = M_("bbs--Message").db.add
		if id > 0 then
			Call K_("bbs--Mail").sendMessage(id)
			that.success("发送成功！")
		end if		
	end sub
	
	'删除消息
	sub removeMessage
		dim id,where
		id = that.req("id")
		
		set where = D_
		where("ToUser") = S_("adminId")
		if not isNul(id) then
			where("MessageID") = Array( "IN" , id )
		end if
		B_("self_GuestMessage").where(where).remove
		that.success("删除成功")
	end sub
	
	'基本设置页面
	sub settings
		dim obj,templatePath
		set obj = objCMS
		templatePath= obj.getTemplatePath( "user/set" )		
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'上传头像
	sub upload
		dim filename
		POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		filename = POP_MVC.upload("file")
		if filename <> "" then
			Call B_(tableName).where( S_("adminId") ).setField( "Avatar" , filename )
			that.success( filename )
		else
			that.error( POP_MVC.Uploader.description )
		end if
	end sub
	
	'修改信息
	sub editInfo
		dim dict,key
		set dict = POP_MVC.form2dict
		
		'全部去掉html标签
		for each key in dict
			dict(key) = POP_MVC.String.strip_tags( dict(key) , "html" )
		next
		
		if not M_("bbs--user").db.data(dict).create(2) then
			that.error( Array(M_("bbs--user").db.error ,-1 ) )
		end if
		
		set dict = M_("bbs--user").db.getData
		if M_("bbs--user").db.data(dict).where( S_("adminId") ).Save then
			that.success( Array("修改成功" , "?user_settings_" & POP_MVC.String.uniqid() & "#info") )
		end if
	end sub
	
	'修改密码操作
	sub editPassword
		'验证
		Call set_password_check
		
		if not B_("user").create(2) then
			that.error( Array(B_("user").error ,-1 ) )
		end if
	
		call B_("user").where( S_("adminId")  ).setField( "Password" , md5( that.form("newpassword") ) )
		
		that.success( Array("密码修改成功" , "?user_settings_" & POP_MVC.String.uniqid() & "#pass") )	
	end sub
	
	'修改密码操作
	sub editLoginName
		dim fieldName,fieldValue,where
		fieldName = that.req("fieldName")
		fieldValue = that.req("fieldValue")

		'验证
		if not M_("bbs--user").checkUserName( fieldValue ) then
			that.error( M_("bbs--user").checkUserNameTip() )
		end if
		
		set where = D_
		where("UserID") = Array("neq" , S_("adminId"))
		where("LoginName") = fieldValue
		
		if B_(tableName).where(where).count() > 0 then
			that.error("该用户名已经被使用，请重试别的！")
		end if
		
		Call B_(tableName).where( that.dict( "UserID" , S_("adminId") ) ).setField( "LoginName" , fieldValue )
		
		Session("adminName") = fieldValue
		
		that.success( Array("登陆名修改成功" , "?user") )	
	end sub
	
	'修改密码操作
	sub editAvatar
		dim fieldName,fieldValue,where
		fieldName = that.req("fieldName")
		fieldValue = that.req("fieldValue")
		
		Call B_(tableName).where( that.dict( "UserID" , S_("adminId") ) ).setField( "Avatar" , fieldValue )
		
		Session("Avatar") = fieldValue
		
		that.success( Array("头像修改成功" , "?user") )	
	end sub
	
	Private sub set_password_check
		B_("user").validate_ = Array( _
			Array( "oldpassword","","旧密码不能为空" , 1 , "notempty" , 3 ) _	
			,Array( "newpassword","","新密码不能为空" , 1 , "notempty" , 3 ) _	
			,Array( "renewpassword","","确认密码不能为空" , 1 , "notempty" , 3 ) _	
			,Array( "newpassword","renewpassword","两次输入密码不一致" , 0 , "confirm" , 3 ) _
			,Array( "newpassword","^\w{6,100}$","密码必须是数字与字母，且长度不能少于6位" , 0 , "regex" , 3 ) _
			,Array( "newpassword","^\w{6,100}$","密码必须是数字与字母，且长度不能少于6位" , 0 , "regex" , 3 ) _
		)
	end sub
	
	'解除绑定
	sub Unbind
		dim stype,field
		stype = that.form( "type" )
		if stype = "qq_id" then
			field = "QQOpenID"
		elseif stype = "weibo_id" then
			field = "WeiboAppKey"
		end if
		Call B_("User").where( S_("adminId") ).setField( field,"" )
		that.success( "解绑成功" )
	end sub
	
	'重新激活
	sub Reactivate
		dim obj,templatePath,dict,errnum
		set obj = objCMS
		set dict = D_
		dict("MailAlert") = POP_MVC.String.uniqid
		dict("SendActivateMailTime") = now()
		Call B_("User").where( S_("adminId") ).setField( dict,null )
		that.d("msg") = "激活邮件已成功发送"
		that.d("info") = "待激活"
		templatePath= obj.getTemplatePath( "user/activateOk" )
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub	
	
	'激活邮箱
	sub activate
		dim obj,templatePath,mailalert
		set obj = objCMS
		mailalert = B_("user").where( S_("adminId") ).field("MailAlert").getOne
		if mailalert = "" then		
			that.d("msg") = "恭喜您已完成邮箱激活操作"
			that.d("info") = "已成功激活"
			templatePath= obj.getTemplatePath( "user/activateOk" )
		else
			templatePath= obj.getTemplatePath( "user/activate" )
		end if	
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'发送激活邮件
	sub SendActivateMail		
		dim obj,templatePath,errnum,dict,MailAlert,rs,bool
		
		bool = false
		set rs = B_("user").where( S_("adminId") ).find
		if rs("MailAlert") <> "" then
			if isDate(rs("SendActivateMailTime")) then
				if guestConfig.ActivateMailTime <> "" then
					if datediff( "h", rs("SendActivateMailTime") , now   ) - guestConfig.ActivateMailTime < 0 then
						bool = true
					end if
				else
					bool = true
				end if
			end if
		end if
		
		set obj = objCMS
		
		if not bool then
			set dict = D_
			MailAlert = POP_MVC.String.uniqid
			that.d("MailAlert") = MailAlert
			dict("MailAlert") = MailAlert
			dict("SendActivateMailTime") = now()
			Call B_("User").where( S_("adminId") ).setField( dict,null )		
			
			
			templatePath= obj.getTemplatePath( "user/activateMail" )		
			obj.load(templatePath)	
			obj.parseHtml
			errnum = K_("Plugin--Public").sendmail( V_("admin.Email"), "iAspCms社区激活邮箱", obj.Content )
			if errnum = 0 then 
				Call B_("User").where( S_("adminId") ).setField( "SendActivateMailTime" , now() )
				that.success("激活邮件已成功发送")
			else
				that.error("由于系统原因，激活邮件发送失败")
			end if
		else
			that.d("msg") = "激活邮件已在 " & rs("SendActivateMailTime") & " 成功发送，请前往邮箱" & rs("Email") & "激活！"
			that.d("info") = "待激活"
			templatePath= obj.getTemplatePath( "user/activateOk" )	
			obj.load(templatePath)	
			obj.parseHtml
			obj.output
		end if
	end sub
	
	'注销账户
	sub setStatusField
		dim StatusField,FieldValue
		StatusField = POP_MVC.req("StatusField")
		FieldValue = POP_MVC.req("FieldValue")
		Call B_(tableName).where( S_("adminId") ).setField( StatusField , FieldValue )	
		'清空Session
		Session.Contents.RemoveAll()
		Session.Abandon		
		'清空Cookie
		P_("cookie").clear
		that.success("注销成功！")			
	end sub
	
	'全部头像
	sub avatar
		dim arr,path,arr2,str,data

		str = B_("self_GuestConfig").field( "SelectOptions" ).where("ConfigName='"& "AvatarType" &"'").getOne()
		set data = K_("bbs--Public").option2data(str)		
		that.d("data") = data

		dim obj,templatePath
		set obj = objCMS		
		templatePath= obj.getTemplatePath( "user/avatar" )
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
end Class
%>