<%
Class Topic 'Extends bbs--Common
	private tableName,orderStr,isSolved
	sub initialize
		tableName = "self_GuestTopic"
		that.d("layuicachepage") = "jie"
	end sub
	
	'添加页面
	sub add
		dim where,lastSortID,templatePath,AddSortID
		AddSortID = that.get("id")
		
		if S_("IsAdmin") <> 1 then
			set where = D_
			
			'判断是否允许普通用户发帖
			if guestConfig.ThreadAddAllow = 0 then
				K_("bbs--Public").showError( guestConfig.ThreadAddAllowTip )
			end if		

			'判断用户是否禁止发帖
			if B_("user").where(S_("adminId")).field("ThreadStatus").getOne = 0 then
				K_( "bbs--Public" ).showError( guestConfig.ThreadForbidTip  )
			end if			
			
			'判断普通用户最大发帖数
			where("UserID") = S_("adminId")			
			if guestConfig.ThreadLimit <> 0 and B_(tableName).where(where).count - guestConfig.ThreadLimit >= 0 then
				K_("bbs--Public").showError( guestConfig.ThreadLimitTip )
			end if				
			
			'判断普通用户日最多发帖数
			where("UserID") = S_("adminId")
			where("AddTime") = Array( "daydiff" , 0 )
			if guestConfig.ThreadDayLimit <> 0 and B_(tableName).where(where).count - guestConfig.ThreadDayLimit >= 0 then
				K_("bbs--Public").showError( guestConfig.ThreadDayLimitTip )
			end if		
		end if
		
		'引入summernote之前,要先引入该模块
		POP_MVC.config( "AUTO_EXTENDS_MODULE" ) = "summernote"
		
		'自动化导入summernote
		that.d("summernote") = P_("auto").summernote("#L_content")
		if AddSortID <> "0" and AddSortID <> "" then
			lastSortID = AddSortID
		else
			lastSortID = B_(tableName).field("SortID").where( "UserID = " & S_("adminId") ).order("TopicID DESC").getOne
		end if
		
		that.d("lastSortID") = lastSortID
		
		'将积分用逗号炸开,形成数组
		templatePath= objCMS.getTemplatePath( iif( S_("adminId") -1 = 0 ,"jie/admin-add" , "jie/add" ) )
		objCMS.load(templatePath)	
		objCMS.parseHtml
		objCMS.output
	end sub
	
	
	'修改页面
	sub edit		
		'判断是否允许普通用户发帖
		if guestConfig.ThreadEditAllow = 0 AND S_("IsAdmin")<>1 then
			K_("bbs--Public").showError( guestConfig.ThreadEditAllowTip )
		end if		
	
		dim id,rs,templatePath,authInfo
		
		if B_("user").where( S_("adminId") ).field("ThreadStatus").getOne = 0 then
			K_( "bbs--Public" ).showError( guestConfig.ThreadForbidTip )
		end if	
		
		id = that.get("id")
		set rs = B_("self_GuestTopic").where(id).find
		
		if rs.eof then
			that.error("要修改的帖子不存在!")
		end if
		
		'判断是否有编辑帖子的权限
		if cstr(rs("UserID")) <> cstr(S_("adminId")) AND S_("IsAdmin") <> 1 then
			that.error("您没有权限编辑该帖子")
		end if
		
		authInfo = K_("bbs--Public").AuthCompare( rs("UserID") , "的帖子进行修改操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if		
		
		that.d("thread") = rs

		POP_MVC.config( "AUTO_EXTENDS_MODULE" ) = "summernote"
		that.d("summernote") = P_("auto").summernote("#L_content")
		templatePath= objCMS.getTemplatePath( iif( S_("adminId") -1 = 0 ,"jie/admin-edit" , "jie/edit" ) )
		objCMS.load(templatePath)	
		objCMS.parseHtml
		objCMS.output
	end sub	
	
	'存草稿
	sub doDraft
		if that.form("TopicID") <> "" then
			Call edit_draft
		else
			Call add_draft
		end if
	end sub
	
	'修改操作
	sub doEdit
		dim id,dict
		
		set dict = POP_MVC.form2dict				
		dict("Title") = POP_MVC.String.strip_tags( dict("Title") , "html" )		
		
		if not M_( "bbs--Thread" ).db.data(dict).create(2) then
			that.error( M_( "bbs--Thread" ).db.error )
		end if
		
		if  M_( "bbs--Thread" ).db.save then
			if dict("EditCount") = "" then
				Call M_( "bbs--Thread" ).db.where( that.form("TopicID") ).setField("EditCount",1)
			else
				Call M_( "bbs--Thread" ).db.where( that.form("TopicID") ).setInc("EditCount")
			end if
			
			if guestConfig.ThreadEditReminded = 1 then
				K_("bbs--mail").EditThread( "" )
			end if
			objCMS.clearCache
			that.success( Array( iif( guestConfig.ThreadEditCheck=0 OR S_("IsAdmin")=1,  "帖子已经修改，且正式发布！"  ,"帖子已经修改，管理员审核后才可正式发布！") , getThreadLink( that.form("TopicID") ) ))	
		else
			'B_("self_GuestConfig").Rollback
			that.error( "修改失败，请重新提交" )
		end if		
	end sub
	
	'添加操作
	sub doAdd
		if that.form("TopicID") <> "" then
			Call doEdit
			Exit Sub
		end if
		dim id,dict,rs,SortID,AnswerReward
		
		set rs = B_("User").where( S_("adminId") ).find
		
		
		'判断用户是否禁止发帖
		if rs("ThreadStatus") = 0 then
			K_( "bbs--Public" ).showError( guestConfig.ThreadForbidTip  )
		end if	
		
		AnswerReward = that.form("AnswerReward")
		
		if AnswerReward = "" then
			AnswerReward = 0
		end if
		
		if rs("Experience") - AnswerReward < 0 then
			that.error( "您的积分不够，不能发帖！" )
		end if
		
		set dict = POP_MVC.form2dict				
		dict("Title") = POP_MVC.String.strip_tags( dict("Title") , "html" )
		
		if not M_( "bbs--Thread" ).db.data(dict).create(1) then
			that.error( M_( "bbs--Thread" ).db.error )
		end if
		
		
		'采用事务处理
		'B_("self_GuestConfig").begin
		
		id = M_( "bbs--Thread" ).db.add
		SortID = that.form("SortID")

		if  id > 0 then
			'B_("self_GuestConfig").commit
			'发帖时减去悬赏分值
			Call B_("User").where( S_("adminId") ).setDec( Array("Experience" , AnswerReward)  )
			
			'发帖时加上奖励积分
			if not is_numeric( guestConfig.ThreadAddReward ) then
				guestConfig.ThreadAddReward = 0				
			end if
			Call B_("User").where( S_("adminId") ).setInc( Array("Experience" , guestConfig.ThreadAddReward)  )
			
			'清空内存首页，与该分类相关的页面
			P_("application").RemovePrefix( "Index/Index" )
			P_("application").RemovePrefix( "Thread_" & SortID )
			
			if guestConfig.ThreadReminded = 1 then
				K_("bbs--mail").AddThread( id )
			end if
			if guestConfig.ThreadAddCheck = 0 or S_("IsAdmin") = 1 then
				objCMS.clearCache
				that.success( Array( "帖子已经添加，且正式发布！" , "?list_" & SortID & guestConfig.PageSuffix ) )
			else				
				that.success( Array( "帖子已经添加，管理员审核后才可正式发布！"  , "?list_" & SortID & guestConfig.PageSuffix ) )
			end if			
		else
			'B_("self_GuestConfig").Rollback
			that.error( "添加失败，请重新提交" )
		end if		
	end sub
	
	'添加存草稿
	private sub add_draft
		dim id,dict,rs,SortID,AnswerReward
		
		set rs = B_("User").where( S_("adminId") ).find
		
		'判断用户是否禁止发帖
		if rs("ThreadStatus") = 0 then
			K_( "bbs--Public" ).showError( guestConfig.ThreadForbidTip  )
		end if	
		
		AnswerReward = that.form("AnswerReward")
		
		if AnswerReward = "" then
			AnswerReward = 0
		end if
		
		if rs("Experience") - AnswerReward < 0 then
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('您的积分不够，不能发帖！'); } )}else{alert('您的积分不够，不能发帖！');}</script>"
			exit sub
		end if
		
		set dict = POP_MVC.form2dict				
		dict("Title") = POP_MVC.String.strip_tags( dict("Title") , "html" )
		
		if not M_( "bbs--Thread" ).db.data(dict).create(1) then
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('" & M_( "bbs--Thread" ).db.error & "'); } )}else{alert('" & M_( "bbs--Thread" ).db.error & "');}</script>"
			exit sub
		end if
		
		
		'采用事务处理
		'B_("self_GuestConfig").begin
		
		id = M_( "bbs--Thread" ).db.add
		SortID = that.form("SortID")

		if  id > 0 then
			'B_("self_GuestConfig").commit
			'发帖时减去悬赏分值
			
			Call  M_( "bbs--Thread" ).db.where(id).setField( "ContentStatus" , 3 )
			Call B_("User").where( S_("adminId") ).setDec( Array("Experience" , AnswerReward)  )
			
			'发帖时加上奖励积分
			if not is_numeric( guestConfig.ThreadAddReward ) then
				guestConfig.ThreadAddReward = 0				
			end if
			Call B_("User").where( S_("adminId") ).setInc( Array("Experience" , guestConfig.ThreadAddReward)  )
			
			'清空内存首页，与该分类相关的页面
			P_("application").RemovePrefix( "Index/Index" )
			P_("application").RemovePrefix( "Thread_" & SortID )
			
			if guestConfig.ThreadReminded = 1 then
				K_("bbs--mail").AddThread( id )
			end if			
			
			response.write "<script>window.parent.document.getElementById('TopicID').value='" & id & "';if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('草稿保存成功'); } )}else{alert('草稿保存成功');}</script>"
		else
			'B_("self_GuestConfig").Rollback
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('草稿保存失败'); } )}else{alert('草稿保存失败');}</script>"
		end if
	end sub
	
	'修改存草稿
	private sub edit_draft
		dim id,dict
		
		set dict = POP_MVC.form2dict	
		id = dict("TopicID")
		dict("Title") = POP_MVC.String.strip_tags( dict("Title") , "html" )		
		
		if not M_( "bbs--Thread" ).db.data(dict).create(2) then
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('" & M_( "bbs--Thread" ).db.error & "'); } )}else{alert('" & M_( "bbs--Thread" ).db.error & "');}</script>"
			exit sub
		end if
		
		if  M_( "bbs--Thread" ).db.save then
			Call  M_( "bbs--Thread" ).db.where(id).setField( "ContentStatus" , 3 )
			if guestConfig.ThreadEditReminded = 1 then
				K_("bbs--mail").EditThread( "" )
			end if
			
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('草稿保存成功'); } )}else{alert('草稿保存成功');}</script>"
		else
			'B_("self_GuestConfig").Rollback
			response.write "<script>if(parent.window.layui){ parent.window.layui.use('layer' ,function(){ parent.window.layui.layer.msg('草稿保存失败'); } )}else{alert('草稿保存失败');}</script>"
		end if		
	end sub
	
	'添加案例
	sub doAddCase
		dim dict,dict2,id
		set dict = POP_MVC.form2dict
		if dict("agree") <> "on" then
			that.error("您需要同意才能提交案例")
		end if
		set dict2 = D_
		dict2("Title") = dict("title")
		dict2("ContentSource") = dict("link")
		dict2("IndexImage") = dict("cover")
		dict2("Content") = dict("desc")
		dict2("Title") = dict("title")
		
		'管理员直接通过审核，而普通用户需要通过审核
		if S_("IsAdmin") = 1 then
			dict2("ContentStatus") = 1
		else
			dict2("ContentStatus") = 0
		end if
		
		dict2("SortID") = POP_MVC.config("BBS_CASE_SORTID")

		if not M_( "bbs--Thread" ).db.data(dict2).create(1) then
			that.error( M_( "bbs--Thread" ).db.error )
		end if
		
		id = M_( "bbs--Thread" ).db.add
		
		if  id > 0 then
			that.success( "您的案例已成功提交，审核通过后将会显示在该页面。敬请留意社区系统消息" )
		else
			that.error( "添加失败，请重新提交" )
		end if	
	end sub
	
	'修改案例
	sub doEditCase
		dim dict,dict2,id
		set dict = POP_MVC.form2dict
		if dict("agree") <> "on" then
			that.error("您需要同意才能提交案例")
		end if
		set dict2 = D_
		dict2("Title") = dict("title")
		dict2("ContentSource") = dict("link")
		dict2("IndexImage") = dict("cover")
		dict2("Content") = dict("desc")
		dict2("Title") = dict("title")
		dict2("TopicID") = dict("id")
		
		'管理员直接通过审核，而普通用户需要通过审核
		if S_("IsAdmin") = 1 then
			dict2("ContentStatus") = 1
		else
			dict2("ContentStatus") = 0
		end if
		
		dict2("SortID") = POP_MVC.config("BBS_CASE_SORTID")

		if not M_( "bbs--Thread" ).db.data(dict2).create(2) then
			that.error( M_( "bbs--Thread" ).db.error )
		end if
		
		if  M_( "bbs--Thread" ).db.save then
			that.success( "您的修改案例已成功提交，审核通过后将会显示在该页面。敬请留意社区系统消息" )
		else
			that.error( "修改失败，请重新提交" )
		end if	
	end sub
	
	
	'设置字段的值，加精/置顶
	Sub setField
		dim field,value,UserID,id,authInfo
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if	
		
		id		= that.req("id")
		field	= that.req("field")
		value	= that.req("rank")
		UserID	= B_( tableName ).where( id ).field("UserID").getOne
		
		authInfo = K_("bbs--Public").AuthCompare( UserID , "的帖子进行该操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if				
		objCMS.clearCache
		if B_(tableName).where( id ).setField( field , value  ) then
			if field = "IsFeatured" then				
				if value - 0 = 0 then
					Call B_("User").where( UserID ).setDec( Array(  "Experience" , guestConfig.ThreadFeaturedReward )  )
					that.success("取消加精成功，减去 " & guestConfig.ThreadFeaturedReward & " 积分" )
				else
					Call B_("User").where( UserID ).setInc( Array(  "Experience" , guestConfig.ThreadFeaturedReward )  )
					that.success("加精成功，奖励 " & guestConfig.ThreadFeaturedReward & " 积分" )
				end if
			elseif field = "IsTop" then
				if value - 0 = 1 then					
					that.success("置顶成功")
				else
					that.success("完成取消置顶")
				end if
			elseif field = "ContentStatus" then
				if value - 1 = 0 then
					that.success("恢复成功")
				else
					that.error("未允许操作")
				end if
			else
				that.success("操作成功")
			end if			
		end if		
	End Sub

	'删除帖子
	'作者只能软删除
	'管理员第一次操作是软删除，第二次操作则会永久删除
	Sub Remove
		dim id,rs,authInfo
		id = that.req("id")
		
		'来路不对
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if			
		
		'不是有效的ID
		if not that.isId( id ) then
			that.error( "非法操作" )
		end if
		
		'根据ID取记录
		set rs = B_(tableName).where(id).find
		
		authInfo = K_("bbs--Public").AuthCompare( rs("UserID") , "的帖子进行删除操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if
		
		'清空内存首页，与该分类相关的页面
		P_("application").RemovePrefix( "Index/Index" )
		P_("application").RemovePrefix( "Thread_" &  rs("SortID") )
		
		if S_("IsAdmin") <> 1 then
			if S_("adminId") = rs("UserID") then
				Call B_(tableName).where(id).setField( "ContentStatus" , 2 )
				objCMS.clearCache
				that.success("删除成功")
			else
				that.error("您不是管理员，无权删除他人的帖子！")
			end if
		else
			if rs("ContentStatus") = 1 then
				Call B_(tableName).where(id).setField( "ContentStatus" , 2 )
				objCMS.clearCache
				that.success("删除成功")
			else
				if S_("GroupID") <> 1 then
					that.error("您不是超级管理员，无权进行彻底删除操作！")
				end if
			
				'彻底删除帖子的时候，还要彻底删除回帖
				B_(tableName).where(id).remove
				B_("self_GuestReply").where( that.dict( "TopicID" , id ) ).remove
				objCMS.clearCache
				that.success( Array("删除成功" ,"" ) )
			end if
		end if		
	End Sub
	
	
	'移除
	sub delete
		dim id,rs,where,refer
		id = that.req("id")
		
		'来路不对
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if	

		if S_("GroupID") <> 1 then
			that.error("您不是超级管理员，无权进行全部删除操作！")
		end if		
		
		set where = D_
		
		refer = Lcase(that.refer)
		
		if inStr( refer, "recycle" ) > 0 then
			where( "ContentStatus" ) = 2
		elseif inStr( refer, "drafts" ) > 0 then
			where( "ContentStatus" ) = 3
		end if	
		
		if id <> "" then
			where("TopicID") = Array( "in" , id )
		end if
		
		Call B_(tableName).where(where).remove
		objCMS.clearCache
		that.success( Array("移除成功" ,"" ) )		
	end sub
	
	'恢复
	sub restore
		dim id,rs,where,refer
		id = that.req("id")
		
		'来路不对
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if	

		if S_("GroupID") <> 1 then
			that.error("您不是管理员，无权进行全部恢复操作！")
		end if		
		
		set where = D_
		
		refer = Lcase(that.refer)
		
		if inStr( refer, "recycle" ) > 0 then
			where( "ContentStatus" ) = 2
		elseif inStr( refer, "drafts" ) > 0 then
			where( "ContentStatus" ) = 3
		end if			
		
		
		if id <> "" then
			where("TopicID") = Array( "in" , id )
		end if
		
		Call B_(tableName).where(where).setField( "ContentStatus" , 1 )
		objCMS.clearCache
		that.success( Array("恢复成功" ,"" ) )
	end sub
	
	'对上传图片提前进行登陆判断
	sub before__upload4summernote
		
		dim dict
		set dict = D_
		if S_("adminId") = "" then			
			dict("status") = that.ajaxErrorStatus
			dict("msg") = "请登陆后发帖"
			dict("url") = false
			that.ajaxData(dict)
		else
			POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		end if
	end sub
	
	
	'上传图片
	sub upload
		dim filename,dict
		POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		filename = POP_MVC.upload("file")
		set dict  = D_
		if filename <> "" then
			dict("status") = that.ajaxSuccessStatus
			dict("url") = filename
			dict("filename") = POP_MVC.file.basename( filename )			
		else
			dict("status") = that.ajaxErrorStatus
			dict("msg") = POP_MVC.Uploader.description
		end if
		that.ajaxData(dict)
	end sub	
end Class
%>