<%
Class Thread  'Extends bbs--Top
	private tableName,orderStr,isSolved,isFeature,theStatus,listAll,isOnlyUser
	private cacheKey,isCached
	
	sub initialize
		tableName = "self_GuestTopic"
		that.d("layuicachepage") = "jie"
		theStatus = 1
		listAll = true
		isOnlyUser = false
	end sub
	
	sub index
		dim content,key,page
		if isEmpty(orderStr) then
			orderStr = "TopicID DESC"
		end if
		
		page = that.get("page")

		
		if page = "" then
			page = 1
		end if
		
		'设置缓存键名
		key = "Thread_" & that.get("SortID") & "_" & POP_MVC.a   & "_" & page
		'防止Application中的内容在过程中遗失，首先获取到
		content = P_("APPLICATION").get( key )	
		
		'只缓存无登陆状态下与前5个页码的页面，所以除了判断是否缓存外，还要判断是否处于无登陆状态与页码范围
		IF page <=5 AND S_("adminId") = "" AND P_("APPLICATION").IsCached( key , guestConfig.AppCacheLifeTime ) AND LCase(POP_MVC.a) <> "search" THEN
			response.write content
		else
			
			Call getListData(that.req("id"))
			
			cacheKey = that.get("c") & "_" & that.get("a") & "_" & that.get("id") & "_" & that.get("page")
			
			isCached = objCMS.isCached( cacheKey , "" )		
			
			objCMS.output	
			
			if page <=5 AND S_("adminId") = "" AND LCase(POP_MVC.a) <> "search" then
				Call P_("APPLICATION").Cache( key , guestConfig.AppCacheLifeTime , objCMS.content )
			end if
		end if
		Call clearRS
	end sub
	
	sub search
		dim SearchInterval
		guestConfig.ListCacheLifeTime=0
		if guestConfig.SearchInterval > 0 and  S_("IsAdmin") <> 1 then
			SearchInterval = P_("cookie").get("LastSearchDate")

			if isDate(SearchInterval) then			
				if datediff( "s" , SearchInterval , now ) - guestConfig.SearchInterval < 0 then
					that.error( Array( "您搜索的太频繁了，系统指定 " & guestConfig.SearchInterval & " 秒钟可搜索一次" , -1 ) )
				end if		
			end if		
			
			P_("cookie").unit = "s"
			P_("cookie").Expires = CInt( guestConfig.SearchInterval )
			P_("cookie").set "LastSearchDate",now
		end if		
	
		if POP_MVC.req("keys") <> "" then
			'限定搜索字符串长度不超过20，可有效防止一句话木马
			if len(POP_MVC.req("keys")) > 20 then
				that.error("搜索字符串不能超过20个字符！！！")
			end if
			that.d("SearchTip") = ""
			that.d("SearchText") = POP_MVC.req("keys")
			
			Call index
		elseif POP_MVC.req("UserID") <> "" then
			if not that.isID(POP_MVC.req("UserID")) then
				that.error("搜索的作者ID不正确！！！")
			end if
			set rs = B_("user").where( POP_MVC.req("UserID") ).field("Nickname,LoginName").find
			if rs.eof then
				that.error("搜索的作者ID不存在！！！")
			end if
			that.d("SearchTip") = "作者"
			if rs("Nickname") <> "" then
				that.d("SearchText") = CStr(rs("Nickname"))
			else
				that.d("SearchText") =  CStr(rs("LoginName"))
			end if
			that.u(rs)
			Call index
		elseif POP_MVC.req("date") <> "" then
			if not isDate( POP_MVC.req("date") ) then
				that.error("搜索的日期格式不正确")
			end if
			that.d("SearchTip") = "日期"
			that.d("SearchText") = POP_MVC.req("date")
			Call index
		elseif POP_MVC.req("isTop") <> "" then
			if not is_numeric( POP_MVC.req("isTop") ) then
				that.error("搜索的日期格式不正确")
			end if
			that.d("SearchTip") = "类型"
			that.d("SearchText") = "置顶"
			Call index
		elseif POP_MVC.req("reward") <> "" then
			if not is_numeric( POP_MVC.req("reward") ) then
				that.error("搜索的 " & guestConfig.RewardTitle & " 格式不正确，应为数字")
			end if
			that.d("SearchTip") = guestConfig.RewardTitle
			that.d("SearchText") = POP_MVC.req("reward")
			Call index
		else
			
		end if	
		if POP_MVC.config("SHOW_PAGE_TRACE") = 0 then
			Call POP_MVC.ClearSqlRS("*")
		end if		
	end sub
	
	sub solved
		isSolved = 1
		if POP_MVC.get("id") = "" then
			Call index
		else
			call list
		end if
	end sub
	
	sub unsolved
		isSolved = 0
		if POP_MVC.get("id") = "" then
			Call index
		else
			call list
		end if
	end sub	
	
	sub feature
		isFeature = "IsFeatured"
		if POP_MVC.get("id") = "" then
			Call index
		else
			call list
		end if
	end sub		
	
	
	sub orderID
		orderStr = "TopicID DESC"

		if POP_MVC.get("id") = "" then
			Call index
		else
			call list
		end if
	end sub
	
	sub orderReply
		orderStr = "ReplyCount DESC,TopicID DESC"
		if POP_MVC.get("id") = "" then
			Call index
		else
			call list
		end if
	end sub		
	
	private sub getListData(SortID)
		dim rsObj,where,template
		
		
		that.d("theAdvLevel") = "钻级"
		that.d("advIds") = "2,3"
		
		set where = D_
		
		
		where("ContentStatus") = theStatus
		
		if SortID <> "" and SortID <> 0 then
			that.d("AddSortID") = SortID
			where("a.SortID") = Array("IN",SortID)
		end if
		
		if not isEmpty( isSolved ) then
			if isSolved = 0 then
				where( "IsSolved" ) = 0
			else
				where( "IsSolved" ) = Array( "<>" ,0 )
			end if			
		end if
		
		where("a.UserID = c.UserID ") = null
		where("a.UserID = c.UserID ") = null		

		if not listAll then
			where( "a.UserID" ) = S_("adminId")
		end if
		
		if isFeature <> "" then
			where( isFeature ) = 1
		end if

		if POP_MVC.req("UserID") <> "" then
			where("c.UserID") = POP_MVC.req("UserID")
		elseif POP_MVC.req("date") <> "" then
			where("a.AddTime") = Array( "date" , POP_MVC.req("date") )
		elseif POP_MVC.req("isTop") <> "" then
			where("isTop") = 1
		elseif POP_MVC.req("reward") <> "" then
			where("a.AnswerReward") = POP_MVC.req("reward")
		end if

		Call B_("self_GuestConfig").onlysql(0).page(array( null, guestConfig.IndexListPageCount ) ).from(C_("THREAD_TABLE")).field(C_("THREAD_FIELD")).where( where )

		if POP_MVC.req("keys") <> "" then
			'适用于搜索
			
			if POP_MVC.req("searchType" ) = "1" then
				set topicRS= B_("self_GuestConfig").search(POP_MVC.req("keys" ),"a.Content" )
			else
				set topicRS= B_("self_GuestConfig").search(POP_MVC.req("keys" ),"a.Title" )
			end if
			that.d("recordCount") = topicRS.RecordCount		
		else
			if orderStr <> "" then
				set topicRS= B_("self_GuestConfig").order(orderStr).select
			else
				set topicRS= B_("self_GuestConfig").select
			end if
			that.d("recordCount") = topicRS.RecordCount
		end if
		
		that.d("thread") = topicRS	
		
		Call getHotTopic(SortID)
		Call getNewReply(SortID)
		
		dim obj
		set obj = objCMS
		
		if LCase(POP_MVC.a) = "search" then
			if POP_MVC.req("keys") <> "" then
				templatePath= obj.getTemplatePath( "jie/search" )
			elseif POP_MVC.req("UserID") <> "" then
				templatePath= obj.getTemplatePath( "jie/search-user" )
			elseif POP_MVC.req("date") <> "" then
				templatePath= obj.getTemplatePath( "jie/search-date" )
			elseif POP_MVC.req("reward") <> "" then
				templatePath= obj.getTemplatePath( "jie/search-reward" )
			elseif POP_MVC.req("isTop") <> "" then
				templatePath= obj.getTemplatePath( "jie/search-top" )
			end if
		else
			template = "jie/index"
			if SortID > 0 then		
				if POP_MVC.file.isFile( obj.getTemplatePath( template & "#" & SortID ) ) then				
					template = template & "#" & SortID
				end if
			end if			
			templatePath= obj.getTemplatePath( template )
		end if
	
		obj.load(templatePath)	
		obj.parseHtml		
	end sub
	
	sub list
		if isEmpty(orderStr) then
			orderStr = "TopicID DESC"
		end if
		
		Call getListData( that.req("id") )
		objCMS.output	
		Call clearRS
	end sub
	
	sub recycle
		if S_("IsAdmin") <> 1 then
			that.error( "您无权查看回收站！" )
			listAll = false
		end if
		that.d("PageName") = "回收站"
		
		if isEmpty(orderStr) then
			orderStr = "TopicID DESC"
		end if

		theStatus = 2
		Call getListData( 0 )
		
		objCMS.output
		Call clearRS
	end sub
	
	sub drafts
		that.d("PageName") = "草稿箱"
		
		if isEmpty(orderStr) then
			orderStr = "TopicID DESC"
		end if
		
		if S_("IsAdmin") <> 1 then
			listAll = false
		end if

		theStatus = 3
		Call getListData( 0 )
		
		objCMS.output
		Call clearRS
	end sub
	
	'对上传图片提前进行登陆判断
	sub before__upload4summernote
		dim dict
		set dict = D_
		if S_("adminId") = "" then			
			dict("status") = that.ajaxErrorStatus
			dict("msg") = "请登陆后发帖"
			dict("url") = false
			that.ajaxData(dict)
		else
			POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		end if
	end sub
	
	Private Function getReplyView( rs )
		dim where
		if guestConfig.ReplyViewMode = 0 then 
			getReplyView = false : exit function
		end if
		
		if S_("IsAdmin") = 1 then
			getReplyView = false : exit function
		end if
		
		if rs("IsReplyView") <> 1 then 
			getReplyView = false : exit function
		end if
		
		if CLng(S_("adminId")) = rs("UserID") then
			getReplyView = false : exit function
		end if
		
		if S_("adminId") <> "" then
			set where = D_
			where("TopicID") = rs("TopicID")
			where("UserID") = S_("adminId")
			if B_("self_GuestReply").where( where ).field("ReplyID").getOne <> "" then
				getReplyView = false : exit function
			end if
		end if
		getReplyView = true
	End Function
	
	'计算某个回复的链接，并跳转。
	sub Reply
		dim thread,id,field,topicRS,where,where2,template,authInfo,pageCnt,page,header
		dim ReplyRS,ReplyID
		
		ReplyID = that.get("ReplyID")
		set ReplyRS = B_("self_GuestReply").where(ReplyID).find
		
		if ReplyRS.eof then
			K_("bbs--Public").showError("回帖不存在")
		end if
		
		
		'''''帖子内容'''''
		id = ReplyRS("TopicID")
		
		that.u(ReplyRS)
		
		set where = D_
		
		
		where("a.TopicID") = id
		where("a.UserID = c.UserID ") = null

		set topicRS= B_("self_GuestConfig").onlysql(0).from(C_("THREAD_TABLE")).field(C_("THREAD_FIELD")).where( where ).find


		'帖子不存在
		if topicRs.eof then
			K_("bbs--Public").show404
			response.end
		end if
		

		if S_("adminId") <> topicRs("UserID")  then
			if S_("IsAdmin") <> 1 then
				if topicRS("ContentStatus") = 0 then
					K_("bbs--Public").showError( "该帖子尚在审核中，暂不能查看" )
					response.end
				elseif topicRS("ContentStatus") = 2 then
					K_("bbs--Public").showError( "该帖子已经被删除" )
					response.end			
				end if
			else
				if topicRS("ContentStatus") = 2 then
					'判断普通管理员是否在查看管理员已删除帖子
					authInfo = K_("bbs--Public").AuthCompare( topicRs("UserID") , "的已删除帖子进行查看！" )
					if authInfo <> "" then
						K_("bbs--Public").showError( authInfo )
						response.end	
					end if							
				end if
			end if
		end if

		'''''回复内容Recordset'''''
		that.u(where)
		
		set where = D_
		
		where("a.TopicID") = id
		where("a.UserID = b.UserID") = null
		where("b.GroupID = c.GroupID") = null
			
		field = "a.ReplyID,a.TopicID,a.ParentID,a.Content,a.IsAdopted,a.Reward,a.ZanCount,a.CaiCount,a.AddTime,b.UserID,b.Online,b.Avatar,b.Gender,b.LoginName,b.Nickname,b.UserStatus,c.GroupID,c.IsAdmin"
		
		where("a.ReplyID") = Array( "<=" , ReplyID )
		
		set replyRS= B_("self_GuestConfig").onlysql(0).page( "null,10" ).from("{prefix}self_GuestReply as a,{prefix}User as b,{prefix}UserGroup as c").field(field).order("a.IsAdopted DESC,a.ReplyID ASC").where( where ).select
		
		pageCnt = replyRS.recordCount
		that.u(replyRS)

		page =  CLng(Abs(Int(- pageCnt / 10)))

		response.redirect( objCMS.getReplyLink( id , ReplyID, page ) )
	end sub
	
	'仅看与某个用户相关的回复
	sub only
		isOnlyUser = true

		Call detail	
	end sub
	
	'帖子详情
	sub detail
		dim id,field,where,where2,template,authInfo,UserID,NoReplyTip,editCount
		dim topicRS,replyRS
		
		NoReplyTip = ""
		
		'''''帖子内容'''''
		id = that.get("ID")
		
		set where = D_
		
		
		where("a.TopicID") = id
		where("a.UserID = c.UserID ") = null
		


		set topicRS= B_("self_GuestConfig").onlysql(0).from(C_("THREAD_TABLE")).field(C_("THREAD_FIELD")).where( where ).find


		'帖子不存在
		if topicRs.eof then
			K_("bbs--Public").show404
			response.end
		end if
		
		that.d("theAdvLevel") = "心级"
		that.d("advIds") = "2"
		that.d("AddSortID") = topicRS("SortID")
		

		if S_("adminId") <> topicRs("UserID")  then
			if S_("IsAdmin") <> 1 then
				if topicRS("ContentStatus") = 0 then
					K_("bbs--Public").showError( "该帖子尚在审核中，暂不能查看" )
					response.end
				elseif topicRS("ContentStatus") = 2 then
					K_("bbs--Public").showError( "该帖子已经被删除" )
					response.end			
				end if
			else
				if topicRS("ContentStatus") = 2 then
					'判断普通管理员是否在查看管理员已删除帖子
					authInfo = K_("bbs--Public").AuthCompare( topicRs("UserID") , "的已删除帖子进行查看！" )
					if authInfo <> "" then
						K_("bbs--Public").showError( authInfo )
						response.end	
					end if							
				end if
			end if
		end if
		
		
		editCount = topicRS("EditCount")
		if isNul( editCount ) then
			editCount = 0
		end if
		that.d("editCount") = editCount

		that.d("thread") = topicRS
		
		that.d("IsReplyView") = getReplyView(topicRS)
		
		'登陆后的回帖提示
		that.d("placeholder") = guestConfig.EditorLoginReplyTip

		'''''回复内容'''''
		if guestConfig.ReplyAddAllow = 0 then
			'是否允许回帖
			NoReplyTip = guestConfig.ReplyAddAllowTip
		elseif topicRS("IsNoComment") = 1 then
			'帖子禁回提示
			NoReplyTip = guestConfig.ReplyNoCommentTip
		elseif datediff( "d" , topicRS("AddTime") , now ) - guestConfig.ReplyTimeLimit > 0 and S_("IsAdmin") - 1 <> 0 then
			'超回帖时间提示
			NoReplyTip = guestConfig.ReplyTimeLimitTip
		elseif topicRS("ReplyCount") - guestConfig.ReplyCountLimit >= 0 then
			'最多回帖提示
			NoReplyTip = guestConfig.ReplyCountLimitTip
		else
			POP_MVC.config( "AUTO_EXTENDS_MODULE" ) = "summernote"
			that.d("summernote") = P_("auto").summernote("#L_content")
			
			if S_("adminId") = "" then
				'未登陆状态的回帖提示
				NoReplyTip = guestConfig.EditorReplyTip
			elseif guestConfig.ReplyDayLimit <> 0 and S_("IsAdmin") <> 1 then
				set where2 = D_
				where2("UserID") = S_("adminId")
				where2("AddTime") = array( "daydiff" , 1 )

				'回帖达到上限后的提示
				if B_("self_GuestReply").where( where2 ).count - guestConfig.ReplyDayLimit >= 0  then
					NoReplyTip = guestConfig.ReplyDayLimitTip
				elseif B_("user").where(S_("adminId")).field("ReplyStatus").getOne = 0 then
					'用户禁回帖提示
					NoReplyTip = guestConfig.ReplyForbidTip
				end if
			end if			
		end if
		that.d("NoReplyTip") = NoReplyTip
		'''''回复内容Recordset'''''
		that.u(where)
		
		set where = D_
		
		where("a.TopicID") = id
		where("a.UserID = b.UserID") = null
		where("b.GroupID = c.GroupID") = null

		if isOnlyUser then
			UserID = that.get("UserID")
			where("(a.UserID = " & UserID & " OR inStr(a.Content, '<a href=""?u_" & UserID & """') > 0  )") = null
		end if
			
		field = "a.ReplyID,a.TopicID,a.ParentID,a.Content,a.IsAdopted,a.Reward,a.ZanCount,a.CaiCount,a.AddTime,b.UserID,b.Online,b.Avatar,b.Gender,b.LoginName,b.Nickname,b.UserStatus,c.GroupID,c.IsAdmin"
		
		set replyRS= B_("self_GuestConfig").onlysql(0).page( "null,10" ).from("{prefix}self_GuestReply as a,{prefix}User as b,{prefix}UserGroup as c").field(field).order("a.IsAdopted DESC,a.ReplyID ASC").where( where ).select
		'POP_MVC.ajax(replyRS.source )
		
		that.d("reply") = replyRS				
	
		Call getHotTopic( topicRS("SortID") )
	
		dim obj
		set obj = objCMS
		template = "jie/detail"
		if POP_MVC.file.isFile( obj.getTemplatePath( template & "#" & topicRS("SortID") ) ) then
			template = template & "#" & topicRS("SortID")
		end if
		templatePath= obj.getTemplatePath( template )
		obj.load(templatePath)	
		POP_MVC.get("theSortID") = topicRS("SortID")
		obj.parseHtml
		obj.output
		Response.flush
		B_("self_GuestTopic").where(id).setInc("Visits")
		Call clearRS
	end sub
	
	'本月/周热议
	Private sub getHotTopic(SortID)
		dim where,rs
		set where = D_
		
		if isCached then
			exit sub
		end if
		
		if SortID <> "" and SortID <> 0 then
			where("SortID") = Array("IN",SortID)
		end if
		where("ReplyCount") = Array(">",0)
		where( "AddTime" ) = Array( "daydiff" , guestConfig.IndexHotDate )
		
		'本周热议
		set rs = B_(tableName).onlysql(0).top(15).order("ReplyCount DESC").field("TopicID,Title,ReplyCount").where( where ).select	
		that.d("HotTopic") = rs
		that.d("HotTopicCount") = rs.recordCount
	end sub
	
	'最新回帖
	Private sub getNewReply(SortID)
		dim where,rs,ids,dict
		set where = D_
		
		if isCached then
			exit sub
		end if
		
		'where( "AddTime" ) = Array( "daydiff" , guestConfig.IndexHotReplyDate )
				
		set where = D_
		'where("b.LanguageID") = config.languageID
		where("ContentStatus") = 1
		where("a.TopicID = b.TopicID") = null
		
		if SortID <> "" and SortID <> 0 then
			where("a.SortID") = Array("IN",SortID)
		end if
		set rs = B_("self_GuestConfig").field("a.TopicID,Title,b.Content as Content,b.AddTime as ReplyTime,b.ZanCount,b.ReplyID").from("{prefix}self_GuestTopic as a, {prefix}self_GuestReply as b").where( where ).top(15).page("null,15").order("ReplyID DESC").select		

		that.d("NewReply") = rs	
		that.d("NewReplyCount") = rs.RecordCount
	end sub
	
	private sub test
		'response.write B_( Array( "content" , "access" , "/iaspcms.mdb" ) ).field("Title,SortID,PageDesc,PageKeywords,IndexImage,IsNoComment,IsTop,IsRecommend,IsHeadline,IsFeatured,Visits,Star,AddTime,DownURL,ContentStatus,EditTime,ContentID as TopicID,ImagePath").xml("Blog" , "")
		
		var_export POP_MVC.file.getFilesMap("./templates/bbs/html","",-1)
		response.end
	end sub
	
	sub clearRS
		if POP_MVC.config("SHOW_PAGE_TRACE") = 0 then
			Call POP_MVC.ClearSqlRS("*")
		end if
	end sub
end Class
%>