<%
Class Thread
	sub init
		'表名 
		'db是popasp_access类的实例化
		db.tableName = "Self_GuestTopic"
		
		'主键
		db.prikey = "TopicID"
		
		db.auto_ = Array( _
			Array( "LanguageID" ,config.languageID,  1 ) _
			,Array( "IsTop" ,0,  1 ) _
			,Array( "IsRecommend" ,0,  1 ) _
			,Array( "IsHeadline" ,0,  1 ) _
			,Array( "IsFeatured" ,0,  1 ) _
			,Array( "IsNoComment" ,0,  1 ) _
			,Array( "Visits" ,0,  1 ) _
			,Array( "Star" ,0,  1 ) _	
			,Array( "AddTime" ,"POP_MVC.FormatDate( now() , ""YYYY-MM-DD HH:II:SS"" )",  1 , "function" ) _
			,Array( "EditTime" ,"POP_MVC.FormatDate( now() , ""YYYY-MM-DD HH:II:SS"" )",  2 , "function" ) _
			,Array( "IndexImage" ,"",  1  ) _
			,Array( "DownURL" ,"",  1  ) _
			,Array( "TitleColor" ,"#000000",  1 ) _
			,Array( "ReplyCount" ,"0",  1 ) _
			,Array( "UserID" , Session("adminId") ,  3 ) _
			,Array( "ContentStatus" , iif(guestConfig.ThreadAddCheck=0 OR S_("IsAdmin")=1,1,0) ,  1 ) _
			,Array( "ContentStatus" , iif(guestConfig.ThreadEditCheck=0 OR S_("IsAdmin")=1,1,0) ,  2 ) _
			,Array( "ZanCount" , 0 ,  1 ) _
			,Array( "CaiCount" , 0 ,  1 ) _
			,Array( "AnswerReward" , 0 ,  1 ) _
			,Array( "IP" , "get_client_ip" ,  1, "function" ) _
			,Array( "Title" , "bbs--Thread.stripTags" , 3 , "callback" , array() )_
			,Array( "Content" , "bbs--Thread.replaceLink" , 3 , "callback" , array() )_
		)
		
		'数据验证
		db.validate_ = Array( _
			 Array( "Title" ,"",  "标题不能为空"  , 1, "notempty" , 3  ) _
			,Array( "Title","1,255","标题长度不能超过255个字符" , 1 , "length" , 3 ) _
			,Array( "SortID",0,"请选择分类" , 1 , "neq" , 3 ) _
			,Array( "SortID","db_id","分类必须是正整数" , 1 , "regex" , 3 ) _
			,Array( "Content" ,"",  "内容不能为空"  , 1, "notempty" , 3  ) _
			,Array( "Content" , guestConfig.ThreadContentLimit & ",40000",  "内容长度不能少于" & guestConfig.ThreadContentLimit & "个字符"  , 1, "length" , 3  ) _
			,Array( "Content","bbs--Thread.TestValidate","有效字符数太少，请修改评论再发布" , 1 , "callback" , 3 , array() ) _
			,Array( "ContentSource","bbs--Thread.SourceValidate","网址不合法" , 0 , "callback" , 3 , array() ) _
			,Array( "verify","","验证码不正确" , 0 , "verify" , 3 ) _
		)
	end sub
	
	function stripTags( value )
		if isNul(value) then
			stripTags = ""
		else
			stripTags = POP_MVC.String.strip_tags( value , "html" )
		end if
		'去掉换行
		stripTags = Replace(stripTags, Chr(10), "")
		stripTags = Replace(stripTags, Chr(13), "")
		
		'将连续三个空格替换成空
		stripTags = Replace(stripTags, "   ", "")
	End function
	
	'替换链接
	'帖子链接{p:1}
	'回复链接{r:1}
	'栏目链接{list:1}
	'幻灯片链接{slide:1},数字为序号,仅限管理员,链接图片展示
	'广告链接{adv:1},数字为序号,仅限管理员,链接图片展示
	'温馨通道中的链接{url:1},数字为序号,仅限管理员
	'友情链接{link:1},数字为序号,仅限管理员
	function replaceLink( byVal value )
		dim rule,mathces,match,i,id,rs,title,limit,sortName,userName,topicRS,where
		dim linkName,linkUrl,linkPic
		limit = 20
		
		'替换帖子链接{p:1}
		rule = "(\{\s*p\s*\:\s*([1-9]\d*)\s*\})"
		if POP_MVC.String.reg_test( value,rule,"i" ) then
			set matches = POP_MVC.String.reg_exec(value,rule,"i")
			i = 0 
			for each match in matches
				if i = limit then
					exit for
				end if
				id = match.subMatches(1)
				set rs = db.where(id).find
				
				if not rs.eof then
					value = replace(value, match.value, "<a href=""" & getThreadLink(id) & """ target=""_blank"" title=""帖子:" & rs("Title") & "，发布于" & rs("AddTime") & """>" & rs("Title") & "</a>" )
				end if
				POP_MVC.unset(rs)
				i = i + 1
			next
			value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
		end if
		
		'替换回复链接{r:1}
		rule = "(\{\s*r\s*\:\s*([1-9]\d*)\s*\})"
		if POP_MVC.String.reg_test( value,rule,"i" ) then
			set matches = POP_MVC.String.reg_exec(value,rule,"i")
			i = 0 
			for each match in matches
				if i = limit then
					exit for
				end if
				id = match.subMatches(1)
				set rs = B_("self_GuestReply").where(id).field("TopicID,AddTime").find
				
				if rs.eof then
					value = POP_MVC.String.reg_replace(value,"<span style='color:red'>帖子回复不存在</span>$1",rule,"i")
				else
					set topicRS= db.where( rs("TopicID") ).field("Title,AddTime").find
					
					if topicRS.eof then
						value = POP_MVC.String.reg_replace(value,"<span style='color:red'>帖子不存在</span>$1",rule,"i")
					else
						value = replace(value, match.value, "<a href=""?Reply_" & id & guestConfig.pageSuffix & """ target=""_blank"" title=""帖子回复:" & topicRS("Title") & "，发帖于" & TopicRs("AddTime") & "，回帖于" & rs("AddTime") & """>" & TopicRs("Title") & "</a>" )
					end if					
				end if
				
				POP_MVC.unset(rs)
				POP_MVC.unset(TopicRS)
				i = i + 1
			next
			value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
		end if
		
		'替换用户链接{u:1}
		rule = "(\{\s*u\s*\:\s*([1-9]\d*)\s*\})"		
		if POP_MVC.String.reg_test( value,rule,"i" ) then
			set matches = POP_MVC.String.reg_exec(value,rule,"i")
			i = 0 
			for each match in matches
				if i = limit then
					exit for
				end if
				id = match.subMatches(1)
				set rs = B_("User").where(id).field("LoginName,Nickname").find
				if not rs.eof then
					userName = iif( isNul(rs("Nickname")) , rs("LoginName"), rs("Nickname")  )
					value = replace(value, match.value, "<a href=""?u_" & id & """ target=""_blank"" title=""用户:" & userName & """>" &  userName & "</a>" )
				end if
				POP_MVC.unset(rs)
				i = i + 1
			next
			value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
		end if		
		
		'替换栏目链接{list:1}
		rule = "(\{\s*list\s*\:\s*([1-9]\d*)\s*\})"
		if POP_MVC.String.reg_test( value,rule,"i" ) then
			set matches = POP_MVC.String.reg_exec(value,rule,"i")
			i = 0 
			for each match in matches
				if i = limit then
					exit for
				end if
				id = match.subMatches(1)
				sortName = getSortName(id)
				value = replace(value, match.value, "<a href=""?list_" & id & guestConfig.PageSuffix & """ target=""_blank"" title=""栏目：" & sortName & """>" & sortName & "</a>" )
				
				i = i + 1
			next
			value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
		end if
		
		if S_("isAdmin") = 1 then
		
			'替换幻灯片链接{slide:1}
			rule = "(\{\s*slide\s*\:\s*([1-9]\d*)\s*\})"
			if POP_MVC.String.reg_test( value,rule,"i" ) then
				set matches = POP_MVC.String.reg_exec(value,rule,"i")
				i = 0 
				for each match in matches
					if i = limit then
						exit for
					end if
					id = match.subMatches(1)
					linkName = objCMS.getArrItem( guestConfig.SlideTitle , id, ","  )
					if linkName <> "" then
						linkUrl = objCMS.getArrItem( guestConfig.SlideUrl , id, ","  )
						linkPic = objCMS.getArrItem( guestConfig.SlideImage , id, ","  )
						value = replace(value, match.value, "<a href=""" & linkUrl &  """ target=""_blank"" title=""幻灯片：" & linkName & """><img src=""" & linkPic & """>" & "</a>" )
					end if				
					i = i + 1
				next
				value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
			end if
			
			'替换广告链接{adv:1}
			rule = "(\{\s*adv\s*\:\s*([1-9]\d*)\s*\})"
			if POP_MVC.String.reg_test( value,rule,"i" ) then
				set matches = POP_MVC.String.reg_exec(value,rule,"i")
				i = 0 
				for each match in matches
					if i = limit then
						exit for
					end if
					id = match.subMatches(1)
					linkName = objCMS.getArrItem( guestConfig.AdvTitle , id, ","  )
					if linkName <> "" then
						linkUrl = objCMS.getArrItem( guestConfig.AdvUrl , id, ","  )
						linkPic = objCMS.getArrItem( guestConfig.AdvImage , id, ","  )
						value = replace(value, match.value, "<a href=""" & linkUrl &  """ target=""_blank"" title=""幻灯片：" & linkName & """><img src=""" & linkPic & """>" & "</a>" )
					end if				
					i = i + 1
				next
				value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
			end if
			
			
			'替换温馨通道中的链接{link:1}
			rule = "(\{\s*url\s*\:\s*([1-9]\d*)\s*\})"
			if POP_MVC.String.reg_test( value,rule,"i" ) then
				set matches = POP_MVC.String.reg_exec(value,rule,"i")
				i = 0 
				for each match in matches
					if i = limit then
						exit for
					end if
					id = match.subMatches(1)
					linkName = objCMS.getArrItem( guestConfig.SideLinkName , id, ","  )
					if linkName <> "" then
						linkUrl = objCMS.getArrItem( guestConfig.SideLinkUrl , id, ","  )
						value = replace(value, match.value, "<a href=""" & linkUrl &  """ target=""_blank"" title=""温馨通道：" & linkName & """>" & linkName & "</a>" )
					end if				
					i = i + 1
				next
				value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
			end if
			
			'替换友情链接{link:1}
			rule = "(\{\s*link\s*\:\s*([1-9]\d*)\s*\})"
			if POP_MVC.String.reg_test( value,rule,"i" ) then
				set matches = POP_MVC.String.reg_exec(value,rule,"i")
				i = 0 
				for each match in matches
					if i = limit then
						exit for
					end if
					id = match.subMatches(1)
					linkName = objCMS.getArrItem( guestConfig.LinksSiteName , id, ","  )
					if linkName <> "" then
						linkUrl = objCMS.getArrItem( guestConfig.LinksSiteUrl , id, ","  )
						value = replace(value, match.value, "<a href=""" & linkUrl &  """ target=""_blank"" title=""友情链接：" & linkName & """>" & linkName & "</a>" )
					end if				
					i = i + 1
				next
				value = POP_MVC.String.reg_replace(value,"<!-- 超过" & limit & "个不显示 $1" & " -->",rule,"i")
			end if
		end if
		

		replaceLink = value

	End function
	
	function TestValidate( Message ) 
		dim str,cnt
		if S_("IsAdmin") = 1 then
			TestValidate = true
			exit function
		end if
		str = POP_MVC.String.strip_tags( Message , "html" )
		str = replace( str , " " ,"" )
		str = POP_MVC.String.unique(str)
		if len( str ) < 5 then
			TestValidate = false
		else
			TestValidate = true
		end if
	end function
	
	function SourceValidate( url ) 
		SourceValidate = true
		if guestConfig.CaseSourceSelf = 1 then
			if not POP_MVC.isSameOrigin( "" ,url ) then
				SourceValidate = false
			end if
		end if
	end function
End Class
%>