<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: viewthread.php,v $
	$Revision: 1.166.2.7 $
	$Date: 2007/03/08 20:17:03 $
*/

define('CURSCRIPT', 'viewthread');
define('SQL_ADD_THREAD', ' t.dateline, t.special, t.lastpost AS lastthreadpost,');

require_once './include/common.inc.php';
require_once DISCUZ_ROOT.'./include/forum.func.php';
supe_dbconnect();


$page = max(1, intval($page));

if($cachethreadlife && $forum['threadcaches'] && !$discuz_uid && $page == 1 && !$forum['special']) {

	$forum['livedays'] = ceil(($timestamp - $forum['dateline']) / 86400);
	$forum['lastpostdays'] = ceil(($timestamp - $forum['lastthreadpost']) / 86400);

	$threadcachemark = 100 - (
		$forum['displayorder'] * 15 +
		$forum['digest'] * 10 +
		min($forum['views'] / max($forum['livedays'], 10) * 2, 50) +
		max(-10, (15 - $forum['lastpostdays'])) +
		min($forum['replies'] / $_DCACHE['settings']['postperpage'] * 1.5, 15));

	if($threadcachemark < $forum['threadcaches']) {

		$threadcache = getcacheinfo($tid);

		if($timestamp - $threadcache['filemtime'] > $cachethreadlife) {
			@unlink($threadcache['filename']);
			define('CACHE_FILE', $threadcache['filename']);

		} else {
			readfile($threadcache['filename']);

			$supe_pushstatusadd = '';
			viewthread_updateviews();

			$debug && debuginfo();
			die('<script type="text/javascript">document.getElementById("debuginfo").innerHTML = " '.($debug ? 'Update at '.gmdate("H:i:s", $threadcache['filemtime'] + 3600 * 8).', Processed in '.$debuginfo['time'].' second(s), '.$debuginfo['queries'].' Queries'.($gzipcompress ? ', Gzip enabled' : '') : '').'";</script>');
		}
	}
}

require_once DISCUZ_ROOT.'./include/discuzcode.func.php';

$discuz_action = 3;

$query = $db->query("SELECT * FROM {$tablepre}threads t WHERE tid='$tid' AND displayorder>='0'");

$lastmod = array();

if(!$thread = $db->fetch_array($query)) {

	$tid = $_GET['tid'];
	if(is_numeric($tid) && $supe['status'] && !empty($supe_fromsupesite) && md5("$discuz_auth_key-$tid") == $supe_fromsupesite) {
		supe_dbconnect();
		$supe['db']->query("UPDATE {$supe[tablepre]}spaceitems SET tid='0' WHERE tid='$tid'");
	}

	showmessage('thread_nonexistence');

} elseif($thread['moderated']) {
	$query = $db->query("SELECT uid AS moduid, username AS modusername, dateline AS moddateline, action AS modaction, magicid
		FROM {$tablepre}threadsmod
		WHERE tid='$tid' ORDER BY dateline DESC LIMIT 1");
	if($lastmod = $db->fetch_array($query)) {
		include language('modactions');
		$lastmod['modusername'] = $lastmod['modusername'] ? $lastmod['modusername'] : 'System';
		$lastmod['moddateline'] = gmdate("$dateformat $timeformat", $lastmod['moddateline'] + $timeoffset * 3600);
		$lastmod['modaction'] = $modactioncode[$lastmod['modaction']];
		if($lastmod['magicid']) {
			require_once DISCUZ_ROOT.'./forumdata/cache/cache_magics.php';
			$lastmod['magicname'] = $_DCACHE['magics'][$lastmod['magicid']]['name'];
		}

	} else {
		$db->query("UPDATE {$tablepre}threads SET moderated='0' WHERE tid='$tid'", 'UNBUFFERED');
	}
}

$supe_fromdiscuz = $supe['status'] && $thread['itemid'] ? md5("$discuz_auth_key-$thread[itemid]") : '';
$iscircle = $supe['status'] && $supe['circlestatus'] && $forum['status'] == 2 && $thread['sgid'];

$codecount = 0;
$thread['subjectenc'] = rawurlencode($thread['subject']);
$fromuid = $creditspolicy['promotion_visit'] && $discuz_uid ? '&amp;fromuid='.$discuz_uid : '';

$oldtopics = isset($_DCOOKIE['oldtopics']) ? $_DCOOKIE['oldtopics'] : 'D';
if(strpos($oldtopics, 'D'.$tid.'D') === FALSE) {
	$oldtopics = 'D'.$tid.$oldtopics;
	if(strlen($oldtopics) > 3072) {
		$oldtopics = preg_replace("((D\d+)+D).*$", "\\1", substr($oldtopics, 0, 3072));
	}
	dsetcookie('oldtopics', $oldtopics, 3600);
}

if($lastvisit < $thread['lastpost'] && (!isset($_DCOOKIE['fid'.$fid]) || $thread['lastpost'] > $_DCOOKIE['fid'.$fid])) {
	dsetcookie('fid'.$fid, $thread['lastpost'], 3600);
}
$navigation = '&raquo; <a href="'.($iscircle ? $supe['siteurl'].'?action_mygroup_gid_'.$thread['sgid'].'_op_list_type_bbs_fid_'.$fid : 'forumdisplay.php?fid='.$fid.($extra ? '&amp;'.preg_replace("/^(&amp;)*/", '', $extra) : '')).'">'.$forum[name].'</a> &raquo; '.$thread[subject];
$navtitle = $thread['subject'].' - '.strip_tags($forum['name']);
if($forum['type'] == 'sub') {
	$query = $db->query("SELECT fid, name FROM {$tablepre}forums WHERE fid='$forum[fup]'");
	$fup = $db->fetch_array($query);
	$navigation = '&raquo; <a href="'.($iscircle ? $supe['siteurl'].'?action_mygroup_gid_'.$thread['sgid'].'_op_list_type_bbs_fid_'.$fup[fid] : 'forumdisplay.php?fid='.$fup[fid]).'">'.$fup[name].'</a> '.$navigation;
	$navtitle = $navtitle.' - '.strip_tags($fup['name']);
}
$navtitle .= ' - ';

if($thread['typeid'] && isset($forum['threadtypes']['types'][$thread['typeid']])) {
	$thread['subject'] = ($forum['threadtypes']['listable'] ? '<a href="forumdisplay.php?fid='.$fid.'&amp;filter=type&amp;typeid='.$thread['typeid'].'">['.$forum['threadtypes']['types'][$thread['typeid']].']</a>' : '['.$forum['threadtypes']['types'][$thread['typeid']].']').' '.$thread['subject'];
}
if(empty($forum['allowview'])) {
	if(!$forum['viewperm'] && !$readaccess) {
		showmessage('group_nopermission', NULL, 'NOPERM');
	} elseif($forum['viewperm'] && !forumperm($forum['viewperm'])) {
		$navtitle = '';
		showmessage('forum_nopermission', NULL, 'NOPERM');
	}
}

if($forum['password'] && $forum['password'] != $_DCOOKIE['fidpw'.$fid]) {
	dheader("Location: {$boardurl}forumdisplay.php?fid=$fid&amp;sid=$sid");
}

if($thread['readperm'] && $thread['readperm'] > $readaccess && !$forum['ismoderator'] && $thread['authorid'] != $discuz_uid) {
	showmessage('thread_nopermission', NULL, 'NOPERM');
}

if($thread['price'] > 0 && $thread['special'] == 0) {

	if($maxchargespan && $timestamp - $thread['dateline'] >= $maxchargespan * 3600) {
		$db->query("UPDATE {$tablepre}threads SET price='0' WHERE tid='$tid'");
		$thread['price'] = 0;
	} else {
		if(!$discuz_uid) {
			showmessage('group_nopermission', NULL, 'NOPERM');

		} elseif(!$forum['ismoderator'] && $thread['authorid'] != $discuz_uid) {
			$query = $db->query("SELECT tid FROM {$tablepre}paymentlog WHERE tid='$tid' AND uid='$discuz_uid'");
			if(!$db->num_rows($query)) {
				require_once DISCUZ_ROOT.'./include/threadpay.inc.php';
				exit();
			}
		}
	}
}

if($iscircle) {
        require_once DISCUZ_ROOT.'./include/supesite_circle.inc.php';
}

$raterange = $modratelimit && $adminid == 3 && !$forum['ismoderator'] ? array() : $raterange;

$extra = rawurlencode($extra);

$allowgetattach = !empty($forum['allowgetattach']) || ($allowgetattach && !$forum['getattachperm']) || forumperm($forum['getattachperm']);

$postlist = $attachtags = $attachlist = array();
$attachpids = $announcepm = 0;
if(empty($action) && $tid) {

	$pmlist = array();
	if($_DCACHE['pmlist']) {
		$readapmids = !empty($_DCOOKIE['readapmid']) ? explode('D', $_DCOOKIE['readapmid']) : array();
		foreach($_DCACHE['pmlist'] as $pm) {
			if($discuz_uid && (empty($pm['groups']) || in_array($groupid, $pm['groups']))) {
				if(!in_array($pm['id'], $readapmids)) {
					$pm['announce'] = TRUE;
					$pmlist[] = $pm;
					$announcepm++;
				}
			}
		}
	}
	if($discuz_uid && $newpm) {
		require_once DISCUZ_ROOT.'./include/pmprompt.inc.php';
	}

	$showsettings = str_pad(decbin($showsettings), 3, '0', STR_PAD_LEFT);

	$customshow = $discuz_uid ? str_pad(base_convert($customshow, 10, 3), 3, '0', STR_PAD_LEFT) : '222';

	$showsignatures = $customshow{0} == 2 ? $showsettings{0} : $customshow{0};
	$showavatars = $customshow{1} == 2 ? $showsettings{1} : $customshow{1};
	$showimages = $customshow{2} == 2 ? $showsettings{2} : $customshow{2};
	$allowpaytoauthor = $forum['allowpaytoauthor'];

	//get qihoo status (pos. -3)
	$searchboxstatus = substr(sprintf('%03b', $qihoo_searchbox), -3, 1);

	$highlightstatus = isset($highlight) && str_replace('+', '', $highlight) ? 1 : 0;
	$maxsigrows = $maxsigrows ? 'style="overflow: hidden; max-height: '.$maxsigrows.'em; maxHeightIE: '.($maxsigrows * intval(FONTSIZE) + 5).'px;"' : '';

	$ppp = $forum['threadcaches'] && !$discuz_uid ? $_DCACHE['settings']['postperpage'] : $ppp;
	$start_limit = $numpost = ($page - 1) * $ppp;
	if($start_limit > $thread['replies']) {
		$start_limit = $numpost = 0;
		$page = 1;
	}
	$multipage = multi($thread['replies'] + 1, $ppp, $page, "viewthread.php?tid=$tid&amp;extra=$extra".(isset($highlight) ? "&amp;highlight=".rawurlencode($highlight) : ''));

	if($thread['special'] > 0) {
		include_once DISCUZ_ROOT.'./include/special.inc.php';
	}

	$extcredits_thread = array();

	if(!empty($extcredits)) {
		foreach($extcredits as $key => $value) {
			if($value['showinthread']) {
				$extcredits_thread['extcredits'.$key] = array('title' => $value['title'], 'unit' => $value['unit']);
			}
		}
	}

	$fieldsadd = '';
	if(is_array($_DCACHE['fields_thread'])) {
		foreach($_DCACHE['fields_thread'] as $field) {
			$fieldsadd .= ', mf.field_'.$field['fieldid'];
		}
	}

	$newpostanchor = $postcount = $ratelogpids = 0;

	$onlineauthors = array();
	$query = $db->query("SELECT p.*, m.uid, m.username, m.groupid, m.adminid, m.regdate, m.lastactivity, m.posts, m.digestposts, m.oltime,
		m.pageviews, m.credits, m.extcredits1, m.extcredits2, m.extcredits3, m.extcredits4, m.extcredits5, m.extcredits6,
		m.extcredits7, m.extcredits8, m.email, m.gender, m.showemail, m.invisible, m.xspacestatus, mf.nickname, mf.site,
		mf.icq, mf.qq, mf.yahoo, mf.msn, mf.taobao, mf.alipay, mf.location, mf.medals, mf.avatar, mf.avatarwidth,
		mf.avatarheight, mf.sightml AS signature, mf.customstatus, mf.spacename $fieldsadd
		FROM {$tablepre}posts p
		LEFT JOIN {$tablepre}members m ON m.uid=p.authorid
		LEFT JOIN {$tablepre}memberfields mf ON mf.uid=m.uid
		WHERE p.tid='$tid' AND p.invisible='0' ORDER BY dateline LIMIT $start_limit, $ppp");

	while($post = $db->fetch_array($query)) {

		if(!$newpostanchor && $post['dateline'] > $lastvisit) {
			$post['newpostanchor'] = '<a name="newpost"></a>';
			$newpostanchor = 1;
		} else {
			$post['newpostanchor'] = '';
		}
		$post['lastpostanchor'] = $numpost == $thread['replies'] ? '<a name="lastpost"></a>' : '';
		$post['number'] = ++$numpost;
		$post['count'] = $postcount++;
		$post['thisbg'] = $thisbg = isset($thisbg) && $thisbg == 'altbg1' ? 'altbg2' : 'altbg1';
		$post['dbdateline'] = $post['dateline'];
		$post['dateline'] = gmdate("$dateformat $timeformat", $post['dateline'] + $timeoffset * 3600);
		$post['groupid'] = $_DCACHE['usergroups'][$post['groupid']] ? $post['groupid'] : 7;

		if($post['username']) {
			$onlineauthors[] = $post['authorid'];
			$post['groupid'] = getgroupid($post['authorid'], $_DCACHE['usergroups'][$post['groupid']], $post);
			$post['readaccess'] = $_DCACHE['usergroups'][$post['groupid']]['readaccess'];
			if($userstatusby == 1 || $_DCACHE['usergroups'][$post['groupid']]['byrank'] === '0') {
				$post['authortitle'] = $_DCACHE['usergroups'][$post['groupid']]['grouptitle'];
				$post['stars'] = $_DCACHE['usergroups'][$post['groupid']]['stars'];
			} elseif($userstatusby == 2) {
				foreach($_DCACHE['ranks'] as $rank) {
					if($post['posts'] > $rank['postshigher']) {
						$post['authortitle'] = $rank['ranktitle'];
						$post['stars'] = $rank['stars'];
						break;
					}
				}
			}

			if(!$allowpaytoauthor) {
				$post['alipay'] = '';
			}

			$post['taobao'] = addslashes($post['taobao']);
			$post['authoras'] = !$post['anonymous'] ? ' '.addslashes($post['author']) : '';
			$post['regdate'] = gmdate($dateformat, $post['regdate'] + $timeoffset * 3600);
			$post['allowuseblog'] = $_DCACHE['usergroups'][$post['groupid']]['allowuseblog'];

			if($post['medals']) {
				require_once DISCUZ_ROOT.'./forumdata/cache/cache_medals.php';
				foreach($post['medals'] = explode("\t", $post['medals']) as $key => $medalid) {
					if(isset($_DCACHE['medals'][$medalid])) {
						$post['medals'][$key] = $_DCACHE['medals'][$medalid];
					} else {
						unset($post['medals'][$key]);
					}
				}

			}

			if($showavatars) {
				if($_DCACHE['usergroups'][$post['groupid']]['groupavatar']) {
					$post['avatar'] = '<img src="'.$_DCACHE['usergroups'][$post['groupid']]['groupavatar'].'" border="0" alt="" />';
				} elseif($_DCACHE['usergroups'][$post['groupid']]['allowavatar'] && $post['avatar']) {
					$post['avatar'] = '<div class="avatar" style="width: '.$post['avatarwidth'].'"><img src="'.$post['avatar'].'" width="'.$post['avatarwidth'].'" height="'.$post['avatarheight'].'" border="0" alt="" /></div>';
				} else {
					$post['avatar'] = '';
				}
			}

		} else {

			if(!$post['authorid']) {
				$post['useip'] = substr($post['useip'], 0, strrpos($post['useip'], '.')).'.x';
			}

		}

		$post['attachments'] = array();
		if($post['attachment'] && $allowgetattach) {
			$attachpids .= ",$post[pid]";
			$post['attachment'] = 0;
			if(preg_match_all("/\[attach\](\d+)\[\/attach\]/i", $post['message'], $matchaids)) {
				$attachtags[$post['pid']] = $matchaids[1];
			}
		}

		if($ratelogrecord && $post['ratetimes']) $ratelogpids .= ','.$post['pid'];

		$forum['allowbbcode'] = $forum['allowbbcode'] ? ($_DCACHE['usergroups'][$post['groupid']]['allowcusbbcode'] ? 2 : 1) : 0;

		$post['ratings'] = karmaimg($post['rate'], $post['ratetimes']);
		$post['message'] = discuzcode($post['message'], $post['smileyoff'], $post['bbcodeoff'], $post['htmlon'], $forum['allowsmilies'], $forum['allowbbcode'], ($forum['allowimgcode'] && $showimages ? 1 : 0), $forum['allowhtml'], ($forum['jammer'] && $post['authorid'] != $discuz_uid ? 1 : 0), 0, $post['authorid']);
		$post['signature'] = $post['usesig'] ? $post['signature'] : '';
		$postlist[$post['pid']] = $post;

	}

	if($vtonlinestatus == 2 && $onlineauthors) {
		$query = $db->query("SELECT uid FROM {$tablepre}sessions WHERE uid IN(".(implode(',', $onlineauthors)).") AND invisible=0");
		$onlineauthors = array();
		while($author = $db->fetch_array($query)) {
			$onlineauthors[$author['uid']] = 1;
		}
	} else {
		$onlineauthors = array();
	}
	if($ratelogpids) {
		$query = $db->query("SELECT * FROM {$tablepre}ratelog WHERE pid IN ($ratelogpids) ORDER BY dateline DESC");
		while($ratelog = $db->fetch_array($query)) {
			if(count($postlist[$ratelog['pid']]['ratelog']) < $ratelogrecord) {
				$ratelog['dateline'] = gmdate("$dateformat $timeformat", $ratelog['dateline'] + $timeoffset * 3600);
				$ratelog['score'] = $ratelog['score'] > 0 ? '+'.$ratelog['score'] : $ratelog['score'];
				$ratelog['reason'] = dhtmlspecialchars($ratelog['reason']);
				$postlist[$ratelog['pid']]['ratelog'][] = $ratelog;
			}
		}
	}

	if($attachpids) {
		require_once DISCUZ_ROOT.'./include/attachment.func.php';
		parseattach($attachpids, $attachtags, $postlist, $showimages);
	}

	if(empty($postlist)) {
		showmessage('undefined_action', NULL, 'HALTED');
	}

	$relatedthreadlist = array();
	$relatedthreadupdate = FALSE;
	if(!empty($qihoo_status) && $qihoo_relatedthreads && $qihoo_searchbox) {
		$site = site();
		$relatedkeywords = $metakeywords = '';
		$query = $db->query("SELECT expiration, keywords, relatedthreads FROM {$tablepre}relatedthreads WHERE tid='$tid'");
		$related = $db->fetch_array($query);
		if($related['expiration'] > $timestamp) {
			$relatedthreadlist = unserialize($related['relatedthreads']);
			if($related['keywords']) {
				$searchkeywords = rawurlencode(str_replace("\t", ' ', $related['keywords']));
				foreach(explode("\t", $related['keywords']) as $keyword) {
					$relatedkeywords .= $keyword ? '<a href="search.php?srchtype=qihoo&amp;srchtxt='.rawurlencode($keyword).'&amp;searchsubmit=yes" target="_blank"><span class="bold"><font color=red>'.$keyword.'</font></span></a> ' : '';
					$metakeywords .= $keyword ? $keyword.',' : '';
				}
			}
		} else {
			$relatedthreadupdate = TRUE;
			$verifykey = md5($authkey.$tid.$thread['subjectenc'].$charset.$site);
		}
	}
	$relatedthreads = array();
	if(!empty($relatedthreadlist)) {
		if(!isset($_COOKIE['discuz_collapse']) || strpos($_COOKIE['discuz_collapse'], 'relatedthreads') === FALSE) {
			$relatedthreads['img'] = 'collapsed_no.gif';
			$relatedthreads['style'] = '';
		} else {
			$relatedthreads['img'] = 'collapsed_yes.gif';
			$relatedthreads['style'] = 'display: none';
		}
	}

	$visitedforums = $visitedforums ? visitedforums() : '';
	$forumselect = $forummenu = $smmultipage = '';
	if($fastpost && $allowpost && $_DCACHE['smiliesnum'] > $smcols * $smrows) {
		$smpage = max(1, intval($_COOKIE['smpage']));
		$smmultipage = multi($_DCACHE['smiliesnum'], $smcols * $smrows, 1, '###', 0, 4, 1, 'getSmilies');
	}
	if($forumjump && empty($jsmenu[1])) {
		$forumselect = forumselect();
	}

	$usesigcheck = $discuz_uid && $sigstatus ? 'checked' : '';
	$allowpostreply = ((!$thread['closed'] && !checkautoclose()) || $forum['ismoderator']) && ((!$forum['replyperm'] && $allowreply) || ($forum['replyperm'] && forumperm($forum['replyperm'])) || $forum['allowreply']);
	$allowpost = (!$forum['postperm'] && $allowpost) || ($forum['postperm'] && forumperm($forum['postperm'])) || $forum['allowpost'];

	if($allowpost) {
		$allowpostpoll = $allowpostpoll && ($forum['allowpostspecial'] & 1);
		$allowposttrade = $allowposttrade && ($forum['allowpostspecial'] & 2);
		$allowpostreward = $allowpostreward && ($forum['allowpostspecial'] & 4) && isset($extcredits[$creditstrans]);
		$allowpostactivity = $allowpostactivity && ($forum['allowpostspecial'] & 8);
	} else {
		$allowpostpoll = $allowposttrade = $allowpostreward = $allowpostactivity = FALSE;
	}

	$supe_pushstatusadd = '';
	if($supe['status'] && $supe_allowpushthread && $forum['supe_pushsetting']['status'] == 3) {
		if(($thread['views'] && $forum['supe_pushsetting']['filter']['views'] && $thread['views'] >= intval($forum['supe_pushsetting']['filter']['views'])) ||
			($thread['replies'] && $forum['supe_pushsetting']['filter']['replies'] && $thread['replies'] >= intval($forum['supe_pushsetting']['filter']['replies'])) ||
			($thread['digest'] && $forum['supe_pushsetting']['filter']['digest'] && $thread['digest'] >= intval($forum['supe_pushsetting']['filter']['digest'])) ||
			($thread['displayorder'] && $forum['supe_pushsetting']['filter']['displayorder'] && $thread['displayorder'] >= intval($forum['supe_pushsetting']['filter']['displayorder']))) {
			if($thread['supe_pushstatus'] == 0) {
				$supe_pushstatusadd = ", supe_pushstatus='3'";
			}
		} elseif($thread['supe_pushstatus'] == 3) {
			$supe_pushstatusadd = ", supe_pushstatus='0'";
		}
	}

	viewthread_updateviews();

	$forumselect = $forummenu = '';
	if($forumjump) {
		if($jsmenu[1]) {
			$forummenu = forumselect(FALSE, 1);
		} else {
			$forumselect = forumselect();
		}
	}

	include template($iscircle ? 'supesite_viewthread' : 'viewthread');

} elseif($action == 'printable' && $tid) {

	if(ISROBOT) {
		exit(dheader("HTTP/1.1 403 Forbidden"));
	}
	require_once DISCUZ_ROOT.'./include/printable.inc.php';

}

function viewthread_updateviews() {
	global $delayviewcount, $supe_pushstatusadd, $timestamp, $tablepre, $tid, $db, $adminid;

	if(($delayviewcount == 1 || $delayviewcount == 3) && !$supe_pushstatusadd) {
		$logfile = './forumdata/cache/cache_threadviews.log';
		if(substr($timestamp, -2) == '00') {
			require_once DISCUZ_ROOT.'./include/misc.func.php';
			updateviews('threads', 'tid', 'views', $logfile);
		}
		if(@$fp = fopen(DISCUZ_ROOT.$logfile, 'a')) {
			fwrite($fp, "$tid\n");
			fclose($fp);
		} elseif($adminid == 1) {
			showmessage('view_log_invalid');
		}
	} else {

		$db->query("UPDATE {$tablepre}threads SET views=views+1 $supe_pushstatusadd WHERE tid='$tid'", 'UNBUFFERED');
	}
	unset($supe_pushstatusadd);
}

?>