<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: trade.php,v $
	$Revision: 1.25.2.1 $
	$Date: 2007/02/07 15:48:18 $
*/

define('NOROBOT', TRUE);
define('CURSCRIPT', 'trade');

require_once './include/common.inc.php';
require_once DISCUZ_ROOT.'./api/tradeapi.php';


if(empty($ec_id)) {
	showmessage('undefined_action', NULL, 'HALTED');
}

$page = max(1, intval($page));

if(!empty($orderid)) {

	include_once language('misc');

	$query = $db->query("SELECT * FROM {$tablepre}tradelog WHERE orderid='$orderid'");
	$tradelog = $db->fetch_array($query);
	if(empty($tradelog)) {
		showmessage('undefined_action', NULL, 'HALTED');
	}
	$loginurl = 'https://www.alipay.com/trade/query_trade_detail.htm?trade_no='.$tradelog['tradeno'];
	$tradelog['lastupdate'] = gmdate("$dateformat $timeformat", $tradelog['lastupdate'] + $timeoffset * 3600);
	$tradelog['status'] = trade_getstatus($tradelog['status']);

	include template('trade_view');

} else {

	if(!empty($tid)) {
		$query = $db->query("SELECT closed FROM {$tablepre}threads WHERE tid='$tid'");
		if($db->result($query, 0)) {
			showmessage('trade_closed', 'viewthread.php?tid='.$tid.'&page='.$page);
		}
		$query = $db->query("SELECT * FROM {$tablepre}trades WHERE tid='$tid'");
		$trade = $db->fetch_array($query);
		if(empty($trade)) {
			showmessage('undefined_action', NULL, 'HALTED');
		}
		$fromcode = false;

		if($trade['closed']) {
			showmessage('trade_closed', 'viewthread.php?tid='.$tid.'&page='.$page);
		}
	} else {
		if($payto && $seller) {
			parse_str(authcode($payto, 'DECODE'), $trade);
			$trade = daddslashes($trade, 1);
			$query = $db->query("SELECT username FROM {$tablepre}members WHERE uid='$trade[authorid]'");
			$trade['seller'] = addslashes($db->result($query, 0));
			$trade['sellerid'] = $trade['authorid'];
			$trade['account'] = $seller;
			$trade['itemtype'] = 1;
			$trade['ordinaryfee'] = $trade['ordinary_fee'];
			$trade['expressfee'] = $trade['express_fee'];
			$trade['emsfee'] = $trade['ems_fee'];
			$fromcode = true;
			$trade['tid'] = $tid = $fromtid;
		} else {
			showmessage('trade_invalid');
		}
	}

	if($trade['price'] <= 0) {
		showmessage('trade_invalid', 'viewthread.php?tid='.$tid.'&page='.$page);
	}

	$query = $db->query("SELECT m.groupid FROM {$tablepre}threads t LEFT JOIN {$tablepre}members m ON t.authorid=m.uid WHERE t.tid='$tid'");
	$authorgroupid = $db->result($query, 0);
	$query = $db->query("SELECT tradetaxtype,tradetaxs FROM {$tablepre}usergroups WHERE groupid='$authorgroupid'");
	$authortradesetting = $db->fetch_array($query);

	$currentcredit = $creditstrans ? $_DSESSION['extcredits'.$creditstrans] : 0;
	$tax = ($authortradesetting['tradetaxtype'] == 2) ? ceil($trade['price'] * $authortradesetting['tradetaxs'] / 100) : ceil($authortradesetting['tradetaxs']);
	$tax = $trade['price'] > $tax ? $tax : 0;

	if($action != 'trade' && !submitcheck('action')) {
		$discountprice = $trade['price'] - $tax;
		$discountprice = sprintf("%1.2f", $discountprice);
		$discountcredit = $creditstrans ? ($ec_ratio ? floor($ec_ratio * $tax) : 0) : 0;
		$extra = rawurlencode($extra);
		include template('trade');
	} else {

		$discountprice = ($trade['price'] - $tax) * $number;
		$discountcredit = $creditstrans ? ($ec_ratio ? floor($ec_ratio * $tax * $number) : 0) : 0;

		if($discuz_uid && $currentcredit < $discountcredit && $allowdiscount == 'yes') {
			showmessage('trade_credits_no_enough');
		}

		if($trade['sellerid'] == $discuz_uid) {
			showmessage('trade_by_myself');
		} elseif($number <= 0) {
			showmessage('trade_input_no');
		} elseif(!$fromcode && $number > $trade['amount']) {
			showmessage('trade_lack');
		}

		$pay['number'] = $number;

		if($allowdiscount == 'yes') {
			$pay['price'] = $trade['price'] - $tax;
			$price = $pay['price'] * $pay['number'];
			$buyercredits = $discountcredit;
			$pay['commision'] = 0;
		} else {
			$pay['price'] = $trade['price'];
			$price = $pay['price'] * $pay['number'];
			$buyercredits = 0;
			$pay['commision'] = $tax * $pay['number'];
		}

		if(!$discuz_uid) {
			$pay['commision'] = $tax * $pay['number'];
		}

		$orderid = $pay['orderid'] = gmdate('YmdHis', $timestamp + $_DCACHE['settings']['timeoffset'] * 3600).random(18);

		trade_setprice();

		$buyerid = $discuz_uid ? $discuz_uid : 0;
		$discuz_user = $discuz_user ? $discuz_user : $guestuser;

		$payurl = trade_payurl($pay, $trade);
		$tradesubject = dhtmlspecialchars($trade['subject']);
		$buyercontact = dhtmlspecialchars($buyercontact);
		$buyermsg = dhtmlspecialchars($buyermsg);
		$tax = $ec_commision && $tradetaxs && $pay['commision'] ? $pay['commision'] : 0;
		$db->query("INSERT INTO {$tablepre}tradelog
		(tid, orderid, subject, price, quality, itemtype, number, tax, locus, sellerid, seller, selleraccount, buyerid, buyer, buyercontact, buyercredits, buyermsg, lastupdate) VALUES
		('$trade[tid]', '$orderid', '$tradesubject', '$price', '$trade[quality]', '$trade[itemtype]', '$number', '$tax',
		 '$trade[locus]', '$trade[sellerid]', '$trade[seller]', '$trade[account]', '$discuz_uid', '$discuz_user', '$buyercontact', '$buyercredits', '$buyermsg', '$timestamp')");
		if(!$fromcode) {
			$db->query("UPDATE {$tablepre}trades SET lastbuyer='$discuz_user', lastupdate='$timestamp' WHERE tid='".$trade['tid']."'");
		}
		if($buyercredits) {
			$db->query("UPDATE {$tablepre}members SET extcredits$creditstrans=extcredits$creditstrans-$discountcredit WHERE uid='$discuz_uid'");
		}
		showmessage('credits_addfunds_succeed', $payurl);
	}

}

?>