<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: seccode.php,v $
	$Revision: 1.40.2.7 $
	$Date: 2007/03/07 19:50:33 $
*/

define('CURSCRIPT', 'seccode');
define('NOROBOT', TRUE);

if(preg_replace("/https?:\/\/([^\:\/]+).*/i", "\\1", $_SERVER['HTTP_REFERER']) != preg_replace("/([^\:]+).*/", "\\1", $_SERVER['HTTP_HOST'])) {
	exit('Access Denied');
}

require_once './include/common.inc.php';

$seccodedata['width'] = $seccodedata['width'] >= 70 && $seccodedata['width'] <= 140 ? $seccodedata['width'] : 70;
$seccodedata['height'] = $seccodedata['height'] >= 25 && $seccodedata['height'] <= 50 ? $seccodedata['height'] : 25;

if($update) {
	$seccode = random(6, 1) + $seccode{0} * 1000000;
	updatesession();
}

seccodeconvert($seccode);

if(!$nocacheheaders) {
	@dheader("Expires: -1");
	@dheader("Cache-Control: no-store, private, post-check=0, pre-check=0, max-age=0", FALSE);
	@dheader("Pragma: no-cache");
}

if(function_exists('imagecreate') && function_exists('imagecolorset') && function_exists('imagecopyresized') &&
	function_exists('imagecolorallocate') && function_exists('imagechar') && function_exists('imagecolorsforindex') &&
	function_exists('imageline') && function_exists('imagecreatefromstring') && (function_exists('imagegif') || function_exists('imagepng') || function_exists('imagejpeg'))) {

	$bgcontent = seccode_background();

	if($seccodedata['animator'] && function_exists('imagegif')) {

		include_once './include/gifmerge.class.php';
		$trueframe = mt_rand(1, 9);

		for($i = 0; $i <= 9; $i++) {
			$im = imagecreatefromstring($bgcontent);
			$x[$i] = $y[$i] = 0;
			if($i == $trueframe) {
				$seccodedata['ttf'] && function_exists('imagettftext') ? seccode_ttffont() : seccode_giffont();
				$d[$i] = mt_rand(250, 400);
			} else {
				seccode_adulteratefont();
				$d[$i] = mt_rand(5, 15);
			}
			seccode_adulterate();
			ob_start();
			imagegif($im);
			imagedestroy($im);
			$frame[$i] = ob_get_contents();
			ob_end_clean();
		}
		$anim = new GifMerge($frame, 255, 255, 255, 0, $d, $x, $y, 'C_MEMORY');
		dheader('Content-type: image/gif');
		echo $anim->getAnimation();

	} else {

		$im = imagecreatefromstring($bgcontent);
		$seccodedata['ttf'] && function_exists('imagettftext') ? seccode_ttffont() : seccode_giffont();
		seccode_adulterate();

		if(function_exists('imagepng')) {
			dheader('Content-type: image/png');
			imagepng($im);
		} else {
			dheader('Content-type: image/jpeg');
			imagejpeg($im, '', 100);
		}
		imagedestroy($im);

	}

} else {

	$numbers = array
		(
		'B' => array('00','fc','66','66','66','7c','66','66','fc','00'),
		'C' => array('00','38','64','c0','c0','c0','c4','64','3c','00'),
		'E' => array('00','fe','62','62','68','78','6a','62','fe','00'),
		'F' => array('00','f8','60','60','68','78','6a','62','fe','00'),
		'G' => array('00','78','cc','cc','de','c0','c4','c4','7c','00'),
		'H' => array('00','e7','66','66','66','7e','66','66','e7','00'),
		'J' => array('00','f8','cc','cc','cc','0c','0c','0c','7f','00'),
		'K' => array('00','f3','66','66','7c','78','6c','66','f7','00'),
		'M' => array('00','f7','63','6b','6b','77','77','77','e3','00'),
		'P' => array('00','f8','60','60','7c','66','66','66','fc','00'),
		'Q' => array('00','78','cc','cc','cc','cc','cc','cc','78','00'),
		'R' => array('00','f3','66','6c','7c','66','66','66','fc','00'),
		'T' => array('00','78','30','30','30','30','b4','b4','fc','00'),
		'V' => array('00','1c','1c','36','36','36','63','63','f7','00'),
		'W' => array('00','36','36','36','77','7f','6b','63','f7','00'),
		'X' => array('00','f7','66','3c','18','18','3c','66','ef','00'),
		'Y' => array('00','7e','18','18','18','3c','24','66','ef','00'),
		'2' => array('fc','c0','60','30','18','0c','cc','cc','78','00'),
		'3' => array('78','8c','0c','0c','38','0c','0c','8c','78','00'),
		'4' => array('00','3e','0c','fe','4c','6c','2c','3c','1c','1c'),
		'6' => array('78','cc','cc','cc','ec','d8','c0','60','3c','00'),
		'7' => array('30','30','38','18','18','18','1c','8c','fc','00'),
		'8' => array('78','cc','cc','cc','78','cc','cc','cc','78','00'),
		'9' => array('f0','18','0c','6c','dc','cc','cc','cc','78','00')
		);

	foreach($numbers as $i => $number) {
		for($j = 0; $j < 6; $j++) {
			$a1 = substr('012', mt_rand(0, 2), 1).substr('012345', mt_rand(0, 5), 1);
			$a2 = substr('012345', mt_rand(0, 5), 1).substr('0123', mt_rand(0, 3), 1);
			mt_rand(0, 1) == 1 ? array_push($numbers[$i], $a1) : array_unshift($numbers[$i], $a1);
			mt_rand(0, 1) == 0 ? array_push($numbers[$i], $a1) : array_unshift($numbers[$i], $a2);
		}
	}

	$bitmap = array();
	for($i = 0; $i < 20; $i++) {
		for($j = 0; $j < 4; $j++) {
			$n = substr($seccode, $j, 1);
			$bytes = $numbers[$n][$i];
			$a = mt_rand(0, 14);
			array_push($bitmap, $bytes);
		}
	}

	for($i = 0; $i < 8; $i++) {
		$a = substr('012345', mt_rand(0, 2), 1) . substr('012345', mt_rand(0, 5), 1);
		array_unshift($bitmap, $a);
		array_push($bitmap, $a);
	}

	$image = pack('H*', '424d9e000000000000003e000000280000002000000018000000010001000000'.
			'0000600000000000000000000000000000000000000000000000FFFFFF00'.implode('', $bitmap));

	dheader('Content-Type: image/bmp');
	echo $image;

}

function seccode_background() {
	global $seccodedata, $c;

	$im = imagecreate($seccodedata['width'], $seccodedata['height']);
	$backgroundcolor = imagecolorallocate($im, 255, 255, 255);

	$backgrounds = array();
	if($seccodedata['background'] && function_exists('imagecreatefromjpeg') && function_exists('imagecolorat') &&	function_exists('imagecopymerge') &&
		function_exists('imagesetpixel') && function_exists('imageSX') && function_exists('imageSY')) {
		if($handle = @opendir('images/common/seccode/background/')) {
			while($bgfile = @readdir($handle)) {
				if(preg_match('/\.jpg$/i', $bgfile)) {
					$backgrounds[] = 'images/common/seccode/background/'.$bgfile;
				}
			}
			@closedir($handle);
		}
		if($backgrounds) {
			$imwm = imagecreatefromjpeg($backgrounds[array_rand($backgrounds)]);
			$colorindex = imagecolorat($imwm, 0, 0);
			$c = imagecolorsforindex($imwm, $colorindex);
			$colorindex = imagecolorat($imwm, 1, 0);
			imagesetpixel($imwm, 0, 0, $colorindex);
			$c[0] = $c['red'];$c[1] = $c['green'];$c[2] = $c['blue'];
			imagecopymerge($im, $imwm, 0, 0, mt_rand(0, 140 - $seccodedata['width']), mt_rand(0, 50 - $seccodedata['height']), imageSX($imwm), imageSY($imwm), 100);
			imagedestroy($imwm);
		}
	}

	if(!$seccodedata['background'] || !$backgrounds) {
		for($i = 0;$i < 3;$i++) {
			$start[$i] = mt_rand(200, 255);$end[$i] = mt_rand(100, 150);$step[$i] = ($end[$i] - $start[$i]) / $seccodedata['width'];$c[$i] = $start[$i];
		}
		for($i = 0;$i < $seccodedata['width'];$i++) {
			$color = imagecolorallocate($im, $c[0], $c[1], $c[2]);
			imageline($im, $i, 0, $i-$angle, $seccodedata['height'], $color);
			$c[0] += $step[0];$c[1] += $step[1];$c[2] += $step[2];
		}
		$c[0] -= 20;$c[1] -= 20;$c[2] -= 20;
	}

	ob_start();
	imagegif($im);
	imagedestroy($im);
	$bgcontent = ob_get_contents();
	ob_end_clean();
	return $bgcontent;
}

function seccode_giffont() {
	global $seccode, $seccodedata, $im, $c;
	$seccodedir = array();
	if(function_exists('imagecreatefromgif')) {
		$seccoderoot = 'images/common/seccode/';
		$dirs = opendir($seccoderoot);
		while($dir = readdir($dirs)) {
			if($dir != '.' && $dir != '..' && file_exists($seccoderoot.$dir.'/9.gif')) {
				$seccodedir[] = $dir;
			}
		}
	}

	$widthtotal = 0;
	for($i = 0; $i <= 3; $i++) {
		$imcodefile = $seccodedir ? $seccoderoot.$seccodedir[array_rand($seccodedir)].'/'.strtolower($seccode[$i]).'.gif' : '';
		if(!empty($imcodefile) && file_exists($imcodefile)) {
			$font[$i]['file'] = $imcodefile;
			$font[$i]['data'] = getimagesize($imcodefile);
			$font[$i]['width'] = $font[$i]['data'][0] + mt_rand(0, 6) - 4;
			$font[$i]['height'] = $font[$i]['data'][1] + mt_rand(0, 6) - 4;
			$font[$i]['width'] += mt_rand(0, $seccodedata['width'] / 5 - $font[$i]['width']);
			$widthtotal += $font[$i]['width'];
		} else {
			$font[$i]['file'] = '';
			$font[$i]['width'] = 8 + mt_rand(0, $seccodedata['width'] / 5 - 5);
			$widthtotal += $font[$i]['width'];
		}
	}

	$x = mt_rand(1, $seccodedata['width'] - $widthtotal);
	for($i = 0; $i <= 3; $i++) {
		if($font[$i]['file']) {
			$imcode = imagecreatefromgif($font[$i]['file']);
			imagecolorset($imcode, 0 ,$c[0], $c[1], $c[2]);
			imagecopyresized($im, $imcode, $x, mt_rand(0, $seccodedata['height'] - $font[$i]['height']), 0, 0,
				$font[$i]['width'],
				$font[$i]['height'], $font[$i]['data'][0], $font[$i]['data'][1]);
			$x += $font[$i]['width'];
		} else {
			$text_color = imagecolorallocate($im, $c[0], $c[1], $c[2]);
			imagechar($im, 5, $x, mt_rand(0, $seccodedata['height'] - 20), $seccode[$i], $text_color);
			$x += $font[$i]['width'];
		}
	}
}

function seccode_ttffont() {
	global $seccode, $seccodedata, $im, $c;
	$seccoderoot = 'images/common/seccode/font/';
	$dirs = opendir($seccoderoot);
	while($entry = readdir($dirs)) {
		if($entry != '.' && $entry != '..' && strtolower(fileext($entry)) == 'ttf') {
			$seccodettf[] = $entry;
		}
	}
	$widthtotal = 0;
	$smallsize = array_rand(array(0, 1, 2, 3), 2);
	for($i = 0; $i <= 3; $i++) {
		$font[$i]['font'] = $seccoderoot.$seccodettf[array_rand($seccodettf)];
		$font[$i]['angle'] = mt_rand(-40, 40);
		$font[$i]['size'] = in_array($i, $smallsize) ? $seccodedata['width'] / 7 : $seccodedata['width'] / 6;
		$box = imagettfbbox($font[$i]['size'], $font[$i]['angle'], $font[$i]['font'], $seccode[$i]);
		$font[$i]['height'] = max($box[1], $box[3]) - min($box[5], $box[7]);
		$font[$i]['width'] = max($box[2], $box[4]) - min($box[0], $box[6]);
		$font[$i]['width'] += mt_rand(0, $seccodedata['width'] / 6 - $font[$i]['width']);
		$widthtotal += $font[$i]['width'];
	}
	$x = mt_rand($font[0]['angle'] > 0 ? cos(deg2rad(90 - $font[0]['angle'])) * $font[0]['height'] : 1, $seccodedata['width'] - $widthtotal);
	$text_color = imagecolorallocate($im, $c[0], $c[1], $c[2]);
	for($i = 0; $i <= 3; $i++) {
		imagettftext($im, $font[$i]['size'], $font[$i]['angle'],
			$x, mt_rand($font[$i]['height'], $seccodedata['height'] - ($font[$i]['angle'] < 0 ? cos(deg2rad(90 + $font[$i]['angle'])) * $font[$i]['width'] : 1)),
			$text_color, $font[$i]['font'], $seccode[$i]);
		$x += $font[$i]['width'];
	}
}

function seccode_adulterate() {
	global $seccodedata, $im, $c;
	$linenums = mt_rand($seccodedata['width'] / 5, $seccodedata['width'] / 4);
	$linemaxlong = $seccodedata['width'] / 8;
	$linecolor = imagecolorallocate($im, $c[0], $c[1], $c[2]);
	for($i=0; $i <= $linenums; $i++) {
		$linex = mt_rand(0, $seccodedata['width']);
		$liney = mt_rand(0, $seccodedata['height']);
		imageline($im, $linex, $liney, $linex + mt_rand(0, $linemaxlong) - 3, $liney + mt_rand(0, $linemaxlong) - 3, $linecolor);
	}
}

function seccode_adulteratefont() {
	global $seccodedata, $im, $c;
	$seccodeunits = 'BCEFGHJKMPQRTVWXY2346789';
	$x = $seccodedata['width'] / 4;
	$y = $seccodedata['height'] / 10;
	$text_color = imagecolorallocate($im, $c[0], $c[1], $c[2]);
	for($i = 0; $i <= 3; $i++) {
		$adulteratecode = $seccodeunits[mt_rand(0, 23)];
		imagechar($im, 5, $x * $i + mt_rand(0, $x - 10), mt_rand($y, $seccodedata['height'] - 10 - $y), $adulteratecode, $text_color);
	}
}
?>