<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: post.func.php,v $
	$Revision: 1.60.2.6 $
	$Date: 2007/03/01 16:32:18 $
*/

if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

function attach_upload($varname = 'attach') {
	global $db, $tablepre, $extension, $typemaxsize, $allowsetattachperm, $attachperm, $maxprice, $attachprice, $attachdesc, $attachsave, $attachdir, $thumbstatus, $thumbwidth, $thumbheight,
		$maxattachsize, $maxsizeperday, $attachextensions, $watermarkstatus, $watermarktype, $watermarktrans, $watermarkquality, $_FILES, $discuz_uid;

	//watermark filename
	$watermark_file = $watermarktype ? './images/common/watermark.png' : './images/common/watermark.gif';
	$watermarkstatus = $GLOBALS['forum']['disablewatermark'] ? 0 : $watermarkstatus;

	$attachments = $attacharray = array();

	if(isset($_FILES[$varname]) && is_array($_FILES[$varname])) {
		foreach($_FILES[$varname] as $key => $var) {
			foreach($var as $id => $val) {
				$attachments[$id][$key] = $val;
			}
		}
	}

	if(empty($attachments)) {
		return FALSE;
	}

	foreach($attachments as $key => $attach) {

		$attach_saved = false;

		$attach['uid'] = $discuz_uid;
		if(!disuploadedfile($attach['tmp_name']) || !($attach['tmp_name'] != 'none' && $attach['tmp_name'] && $attach['name'])) {
			continue;
		}

		$filename = daddslashes($attach['name']);

		$attach['ext'] = $extension = strtolower(fileext($attach['name']));

		if(substr($attach['type'], 0, 5) == 'image') {
			$attach['isimage'] = 1;
		} else {
			$attach['isimage'] = 0;
		}
		$attach['thumb'] = 0;

		$attach['name'] = htmlspecialchars($attach['name'], ENT_QUOTES);
		if(strlen($attach['name']) > 90) {
			$attach['name'] = 'abbr_'.md5($attach['name']).'.'.$extension;
		}

		if($attachextensions && (!preg_match("/(^|\s|,)".preg_quote($attach['ext'], '/')."($|\s|,)/i", $attachextensions) || !$attach['ext'])) {
			upload_error('post_attachment_ext_notallowed', $attacharray);
		}

		if(empty($attach['size'])) {
			upload_error('post_attachment_size_invalid', $attacharray);
		}

		if($maxattachsize && $attach['size'] > $maxattachsize) {
			upload_error('post_attachment_toobig', $attacharray);
		}

		$query = $db->query("SELECT maxsize FROM {$tablepre}attachtypes WHERE extension='".addslashes($attach['ext'])."'");
		if($type = $db->fetch_array($query)) {
			if($type['maxsize'] == 0) {
				upload_error('post_attachment_ext_notallowed', $attacharray);
			} elseif($attach['size'] > $type['maxsize']) {
				require_once DISCUZ_ROOT.'./include/attachment.func.php';
				$typemaxsize = sizecount($type['maxsize']);
				upload_error('post_attachment_type_toobig', $attacharray);
			}
		}

		if($attach['size'] && $maxsizeperday) {
			if(!isset($todaysize)) {
				$query = $db->query("SELECT SUM(a.filesize) FROM {$tablepre}posts p
					LEFT JOIN {$tablepre}attachments a USING (pid)
					WHERE p.authorid='$GLOBALS[discuz_uid]' AND p.dateline>'$GLOBALS[timestamp]'-86400 AND p.attachment>'0'");
				$todaysize = intval($db->result($query, 0));
			}
			$todaysize += $attach['size'];
			if($todaysize >= $maxsizeperday) {
				upload_error('post_attachment_quota_exceed', $attacharray);
			}
		}

		if($attachsave) {
			switch($attachsave) {
				case 1: $attach_subdir = 'forumid_'.$GLOBALS['fid']; break;
				case 2: $attach_subdir = 'ext_'.$extension; break;
				case 3: $attach_subdir = 'month_'.date('ym'); break;
				case 4: $attach_subdir = 'day_'.date('ymd'); break;
			}
			$attach_dir = $attachdir.'/'.$attach_subdir;
			if(!is_dir($attach_dir)) {
				mkdir($attach_dir, 0777);
				fclose(fopen($attach_dir.'/index.htm', 'w'));
			}
			$attach['attachment'] = $attach_subdir.'/';
		} else {
			$attach['attachment'] = '';
		}

		$attach['attachment'] .= preg_replace("/(php|phtml|php3|php4|jsp|exe|dll|asp|cer|asa|shtml|shtm|aspx|asax|cgi|fcgi|pl)(\.|$)/i", "_\\1\\2",
			date('Ymd').'_'.substr(md5($filename.microtime()), 12).random(12).'.'.$extension);

		$target = $attachdir.'/'.stripslashes($attach['attachment']);

		if(@copy($attach['tmp_name'], $target) || (function_exists('move_uploaded_file') && @move_uploaded_file($attach['tmp_name'], $target))) {
			@unlink($attach['tmp_name']);
			$attach_saved = true;
		}

		if(!$attach_saved && @is_readable($attach['tmp_name'])) {
			@$fp = fopen($attach['tmp_name'], 'rb');
			@flock($fp, 2);
			@$attachedfile = fread($fp, $attach['size']);
			@fclose($fp);

			@$fp = fopen($target, 'wb');
			@flock($fp, 2);
			if(@fwrite($fp, $attachedfile)) {
				@unlink($attach['tmp_name']);
				$attach_saved = true;
			}
			@fclose($fp);

		}

		if($attach_saved) {
			@chmod($target, 0644);
			if(in_array($attach['ext'], array('jpg', 'jpeg', 'gif', 'png', 'swf', 'bmp')) && function_exists('getimagesize') && !@getimagesize($target)) {
				@unlink($target);
				upload_error('post_attachment_ext_notallowed', $attacharray);
			} else {
				$attachinfo = getimagesize($target);
				if(in_array($attachinfo['mime'], array('image/jpeg', 'image/gif', 'image/png'))) {

					if($thumbstatus) {
						$img_w		= $attachinfo[0];
						$img_h		= $attachinfo[1];

						$animatedgif = 0;
						if($attachinfo['mime'] == 'image/gif') {
							if(empty($attachedfile)) {
								$fp = fopen($target, 'rb');
								$attachedfile = fread($fp, $attach['size']);
								fclose($fp);
							}
							$animatedgif = strpos($attachedfile, 'NETSCAPE2.0') === FALSE ? 0 : 1;
						}

						if(!$animatedgif && ($img_w >= $thumbwidth || $img_h >= $thumbheight)) {
							switch($attachinfo['mime']) {
								case 'image/jpeg':
									$attach_photo = imageCreateFromJPEG($target);
									break;
								case 'image/gif':
									$attach_photo = imageCreateFromGIF($target);
									break;
								case 'image/png':
									$attach_photo = imageCreateFromPNG($target);
									break;
							}

							$x_ratio = $thumbwidth / $img_w;
							$y_ratio = $thumbheight / $img_h;

							if(($x_ratio * $img_h) < $thumbheight) {
								$thumb['height'] = ceil($x_ratio * $img_h);
								$thumb['width'] = $thumbwidth;
							} else {
								$thumb['width'] = ceil($y_ratio * $img_w);
								$thumb['height'] = $thumbheight;
							}

							$thumb_photo = imagecreatetruecolor($thumb['width'], $thumb['height']);
							imageCopyreSampled($thumb_photo, $attach_photo ,0, 0, 0, 0, $thumb['width'], $thumb['height'], $img_w, $img_h);
							imageJPEG($thumb_photo, $target.'.thumb.jpg');
							$attach['thumb'] = 1;
						}
					}
					if($watermarkstatus) {
						$watermarkinfo	= getimagesize($watermark_file);
						$watermark_logo = $watermarktype ? imageCreateFromPNG($watermark_file) : imageCreateFromGIF($watermark_file);
						$logo_w		= $watermarkinfo[0];
						$logo_h		= $watermarkinfo[1];
						$img_w		= $attachinfo[0];
						$img_h		= $attachinfo[1];
						$wmwidth	= $img_w - $logo_w;
						$wmheight	= $img_h - $logo_h;

						$animatedgif = 0;
						if($attachinfo['mime'] == 'image/gif') {
							if(empty($attachedfile)) {
								$fp = fopen($target, 'rb');
								$attachedfile = fread($fp, $attach['size']);
								fclose($fp);
							}
							$animatedgif = strpos($attachedfile, 'NETSCAPE2.0') === FALSE ? 0 : 1;
						}

						if(is_readable($watermark_file) && $wmwidth > 10 && $wmheight > 10 && !$animatedgif) {
							switch($attachinfo['mime']) {
								case 'image/jpeg':
									$dst_photo = imageCreateFromJPEG($target);
									break;
								case 'image/gif':
									$dst_photo = imageCreateFromGIF($target);
									break;
								case 'image/png':
									$dst_photo = imageCreateFromPNG($target);
									break;
							}

							switch($watermarkstatus) {
								case 1:
									$x = +5;
									$y = +5;
									break;
								case 2:
									$x = ($img_w - $logo_w) / 2;
									$y = +5;
									break;
								case 3:
									$x = $img_w - $logo_w - 5;
									$y = +5;
									break;
								case 4:
									$x = +5;
									$y = ($img_h - $logo_h) / 2;
									break;
								case 5:
									$x = ($img_w - $logo_w) / 2;
									$y = ($img_h - $logo_h) / 2;
									break;
								case 6:
									$x = $img_w - $logo_w;
									$y = ($img_h - $logo_h) / 2;
									break;
								case 7:
									$x = +5;
									$y = $img_h - $logo_h - 5;
									break;
								case 8:
									$x = ($img_w - $logo_w) / 2;
									$y = $img_h - $logo_h - 5;
									break;
								case 9:
									$x = $img_w - $logo_w - 5;
									$y = $img_h - $logo_h - 5;
									break;
							}

							if($watermarktype) {
								imageCopy($dst_photo, $watermark_logo, $x, $y, 0, 0, $logo_w, $logo_h);
							} else {
								imageAlphaBlending($watermark_logo, true);
								imageCopyMerge($dst_photo, $watermark_logo, $x, $y, 0, 0, $logo_w, $logo_h, $watermarktrans);
							}

							switch($attachinfo['mime']) {
								case 'image/jpeg':
									imageJPEG($dst_photo, $target, $watermarkquality);
									break;
								case 'image/gif':
									imageGIF($dst_photo, $target);
									break;
								case 'image/png':
									imagePNG($dst_photo, $target);
									break;
							}

						}

						$attach['size'] = filesize($target);
					}

				}

				$attach['remote'] = ftpupload($target, $attach['attachment'], $attach['thumb']);
				$attach['perm'] = $allowsetattachperm ? $attachperm[$key] : 0;
				$attach['description'] = cutstr(dhtmlspecialchars($attachdesc[$key]), 100);
				$attach['price'] = $maxprice ? (intval($attachprice[$key]) <= $maxprice ? intval($attachprice[$key]) : $maxprice) : 0;
				$attacharray[$key] = $attach;
			}
		} else {

			upload_error('post_attachment_save_error', $attacharray);
		}
	}

	return !empty($attacharray) ? $attacharray : false;
}

function upload_error($message, $attacharray = array()) {
	if(!empty($attacharray)) {
		foreach($attacharray as $attach) {
			@unlink($GLOBALS['attachdir'].'/'.$attach['attachment']);
		}
	}
	showmessage($message);
}

$ftp['pwd'] = FALSE;
function ftpupload($source, $dest, $havethumb = 0) {
	global $authkey, $ftp;
	if($ftp['on']) {
		require_once DISCUZ_ROOT.'./include/ftp.func.php';
		if(!$ftp['connid']) {
			if(!($ftp['connid'] = dftp_connect($ftp['host'], $ftp['username'], authcode($ftp['password'], 'DECODE', md5($authkey)), $ftp['attachdir'], $ftp['port'], $ftp['ssl']))) {
				return 0;
			}
			$ftp['pwd'] = FALSE;
		}
		$tmp = explode('/', $dest);
		if(count($tmp) > 1) {
			if(!$ftp['pwd'] && !dftp_chdir($ftp['connid'], $tmp[0])) {
				if(!dftp_mkdir($ftp['connid'], $tmp[0])) {
					errorlog('FTP', "Mkdir '$ftp[attachdir]/$tmp[0]' error.", 0);
					return 0;
				}
				if(!function_exists('ftp_chmod') || !dftp_chmod($ftp['connid'], 0777, $tmp[0])) {
					dftp_site($ftp['connid'], "'CHMOD 0777 $tmp[0]'");
				}
				if(!dftp_chdir($ftp['connid'], $tmp[0])) {
					errorlog('FTP', "Chdir '$ftp[attachdir]/$tmp[0]' error.", 0);
					return 0;
				}
				dftp_put($ftp['connid'], 'index.htm', $GLOBALS['attachdir'].'/index.htm', FTP_BINARY);
			}
			$dest = $tmp[1];
			$ftp['pwd'] = TRUE;
		}
		if(dftp_put($ftp['connid'], $dest, $source, FTP_BINARY)) {
			if($havethumb) {
				if(dftp_put($ftp['connid'], $dest.'.thumb.jpg', $source.'.thumb.jpg', FTP_BINARY)) {
					@unlink($source);
					@unlink($source.'.thumb.jpg');
					return 1;
				} else {
					dftp_delete($ftp['connid'], $dest);
				}
			} else {
				@unlink($source);
				return 1;
			}
		}
		errorlog('FTP', "Upload '$source' error.", 0);
	}
	return 0;
}

function checkflood() {
	global $db, $tablepre, $disablepostctrl, $floodctrl, $maxpostsperhour, $discuz_uid, $timestamp, $lastpost, $forum;
	if(!$disablepostctrl && $discuz_uid) {
		$floodmsg = $floodctrl && ($timestamp - $floodctrl <= $lastpost) ? 'post_flood_ctrl' : '';

		if(empty($floodmsg) && $maxpostsperhour) {
			$query = $db->query("SELECT COUNT(*) from {$tablepre}posts WHERE authorid='$discuz_uid' AND dateline>$timestamp-3600");
			$floodmsg = ($userposts = $db->result($query, 0)) && ($userposts >= $maxpostsperhour) ? 'thread_maxpostsperhour_invalid' : '';
		}

		if(empty($floodmsg)) {
			return FALSE;
		} elseif(!defined('CURSCRIPT') || CURSCRIPT != 'wap') {
			showmessage($floodmsg);
		} else {
			wapmsg($floodmsg);
		}
	}
	return FALSE;
}

function checkpost() {
	global $subject, $message, $disablepostctrl, $minpostsize, $maxpostsize;
	if(strlen($subject) > 80) {
		return 'post_subject_toolong';
	}
	if(!$disablepostctrl) {
		if($maxpostsize && strlen($message) > $maxpostsize) {
			return 'post_message_toolong';
		} elseif($minpostsize && strlen(preg_replace("/\[quote\].+?\[\/quote\]/is", '', $message)) < $minpostsize) {
			return 'post_message_tooshort';
		}
	}
	return FALSE;
}

function checkbbcodes($message, $bbcodeoff) {
	return !$bbcodeoff && !preg_match("/\[.+\]/s", $message) ? -1 : $bbcodeoff;
}

function checksmilies($message, $smileyoff) {
	$smilies = array();
	if(!empty($GLOBALS['_DCACHE']['smilies']) && is_array($GLOBALS['_DCACHE']['smilies'])) {
		foreach($GLOBALS['_DCACHE']['smilies']['searcharray'] as $smiley) {
			$smilies[] = substr($smiley, 1, -1);
		}
	}
	return !$smileyoff && !preg_match('/'.implode('|', $smilies).'/', stripslashes($message)) ? -1 : $smileyoff;
}

function updatepostcredits($operator, $uidarray, $creditsarray) {
	global $db, $tablepre, $discuz_uid, $timestamp;

	$membersarray = $postsarray = array();
	foreach((is_array($uidarray) ? $uidarray : array($uidarray)) as $id) {
		$membersarray[intval(trim($id))]++;
	}
	foreach($membersarray as $uid => $posts) {
		$postsarray[$posts][] = $uid;
	}
	$lastpostadd = $uidarray == $discuz_uid ? ", lastpost='$timestamp'" : '';
	$creditsadd1 = '';
	if(is_array($creditsarray)) {
		foreach($creditsarray as $id => $addcredits) {
			$creditsadd1 .= ", extcredits$id=extcredits$id$operator$addcredits*\$posts";
		}
	}
	foreach($postsarray as $posts => $uidarray) {
		$uids = implode(',', $uidarray);
		eval("\$creditsadd2 = \"$creditsadd1\";");
		$db->query("UPDATE {$tablepre}members SET posts=posts+('$operator$posts') $lastpostadd $creditsadd2 WHERE uid IN ($uids)", 'UNBUFFERED');
	}
}

function updateattachcredits($operator, $uidarray, $creditsarray) {
	global $db, $tablepre, $discuz_uid;
	$creditsadd1 = '';
	if(is_array($creditsarray)) {
		foreach($creditsarray as $id => $addcredits) {
			$creditsadd1[] = "extcredits$id=extcredits$id$operator$addcredits*\$attachs";
		}
	}
	if(is_array($creditsadd1)) {
		$creditsadd1 = implode(', ', $creditsadd1);
		foreach($uidarray as $uid => $attachs) {
			eval("\$creditsadd2 = \"$creditsadd1\";");
			$db->query("UPDATE {$tablepre}members SET $creditsadd2 WHERE uid = $uid", 'UNBUFFERED');
		}
	}
}

function updateforumcount($fid) {
	global $db, $tablepre, $lang;

	$query = $db->query("SELECT COUNT(*) AS threadcount, SUM(t.replies)+COUNT(*) AS replycount
		FROM {$tablepre}threads t, {$tablepre}forums f
		WHERE f.fid='$fid' AND t.fid=f.fid AND t.displayorder>='0'");

	extract($db->fetch_array($query));

	$query = $db->query("SELECT tid, subject, author, lastpost, lastposter FROM {$tablepre}threads
		WHERE fid='$fid' AND displayorder>='0' ORDER BY lastpost DESC LIMIT 1");

	$thread = $db->fetch_array($query);

	$thread['subject'] = addslashes($thread['subject']);
	$thread['lastposter'] = $thread['author'] ? addslashes($thread['lastposter']) : $lang['anonymous'];

	$db->query("UPDATE {$tablepre}forums SET posts='$replycount', threads='$threadcount', lastpost='$thread[tid]\t$thread[subject]\t$thread[lastpost]\t$thread[lastposter]' WHERE fid='$fid'", 'UNBUFFERED');
}

function updatethreadcount($tid, $updateattach = 0) {
	global $db, $tablepre, $lang;

	$query = $db->query("SELECT COUNT(*) FROM {$tablepre}posts WHERE tid='$tid' AND invisible='0'");
	$replycount = $db->result($query, 0) - 1;

	$query = $db->query("SELECT author, anonymous, dateline FROM {$tablepre}posts WHERE tid='$tid' AND invisible='0' ORDER BY dateline DESC LIMIT 1");
	$lastpost = $db->fetch_array($query);
	$lastpost['author'] = $lastpost['anonymous'] ? $lang['anonymous'] : addslashes($lastpost['author']);

	if($updateattach) {
		$query = $db->query("SELECT attachment FROM {$tablepre}posts WHERE tid='$tid' AND invisible='0' AND attachment>0 LIMIT 1");
		$attachadd = ', attachment=\''.($db->num_rows($query)).'\'';
	} else {
		$attachadd = '';
	}

	$db->query("UPDATE {$tablepre}threads SET replies='$replycount', lastposter='$lastpost[author]', lastpost='$lastpost[dateline]' $attachadd WHERE tid='$tid'", 'UNBUFFERED');
}

function updatemodlog($tids, $action, $expiration = 0, $iscron = 0) {
	global $db, $tablepre, $timestamp;

	$uid = empty($iscron) ? $GLOBALS['discuz_uid'] : 0;
	$username = empty($iscron) ? $GLOBALS['discuz_user'] : 0;
	$expiration = empty($expiration) ? 0 : intval($expiration);

	$data = $comma = '';
	foreach(explode(',', str_replace(array('\'', ' '), array('', ''), $tids)) as $tid) {
		if($tid) {
			$data .= "{$comma} ('$tid', '$uid', '$username', '$timestamp', '$action', '$expiration', '1')";
			$comma = ',';
		}
	}

	!empty($data) && $db->query("INSERT INTO {$tablepre}threadsmod (tid, uid, username, dateline, action, expiration, status) VALUES $data", 'UNBUFFERED');

}

function isopera() {
	$useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
	if(strpos($useragent, 'opera') !== false) {
		preg_match('/opera(\/| )([0-9\.]+)/', $useragent, $regs);
		return $regs[2];
	}
	return FALSE;
}

function deletethreadcaches($tids) {
	global $cachethreadon;
	if(!$cachethreadon) {
		return FALSE;
	}
	include_once DISCUZ_ROOT.'./include/forum.func.php';
	if(!empty($tids)) {
		foreach(explode(',', $tids) as $tid) {
			$fileinfo = getcacheinfo($tid);
			@unlink($fileinfo['filename']);
		}
	}
	return TRUE;
}

function arrayslice($array, $offset, $length) {
	if(PHP_VERSION >= '5.0.2') {
		return array_slice($array, $offset, $length, TRUE);
	} else {
		$array = array_chunk($array, $length, TRUE);
		return $array[$offset / $length];
	}
}

?>