<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: forum.func.php,v $
	$Revision: 1.31.2.1 $
	$Date: 2007/02/07 15:48:19 $
*/

if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

function checkautoclose() {
	global $timestamp, $forum, $thread;

	if(!$forum['ismoderator'] && $forum['autoclose']) {
		$closedby = $forum['autoclose'] > 0 ? 'dateline' : 'lastpost';
		$forum['autoclose'] = abs($forum['autoclose']);
		if($timestamp - $thread[$closedby] > $forum['autoclose'] * 86400) {
			return 'post_thread_closed_by_'.$closedby;
		}
	}
	return FALSE;
}

function forum(&$forum) {
	global $_DCOOKIE, $timestamp, $timeformat, $dateformat, $discuz_uid, $groupid, $lastvisit, $moddisplay, $timeoffset, $hideprivate, $onlinehold;

	if(!$forum['viewperm'] || ($forum['viewperm'] && forumperm($forum['viewperm'])) || !empty($forum['allowview']) || (isset($forum['users']) && strstr($forum['users'], "\t$discuz_uid\t"))) {
		$forum['permission'] = 2;
	} elseif(!$hideprivate) {
		$forum['permission'] = 1;
	} else {
		return FALSE;
	}

	if($forum['icon']) {
		if(strstr($forum['icon'], ',')) {
			$flash = explode(",", $forum['icon']);
			$forum['icon'] = "<a href=\"forumdisplay.php?fid=$forum[fid]\"><embed src=\"".trim($flash[0])."\" width=\"".trim($flash[1])."\" height=\"".trim($flash[2])."\" type=\"application/x-shockwave-flash\" align=\"left\"></embed></a>";
		} else {
			$forum['icon'] = "<a href=\"forumdisplay.php?fid=$forum[fid]\"><img src=\"$forum[icon]\" align=\"left\" alt=\"\" border=\"0\" /></a>";
		}
	}

	$lastpost = array('tid' => 0, 'dateline' => 0, 'subject' => '', 'author' => '');
	list($lastpost['tid'], $lastpost['subject'], $lastpost['dateline'], $lastpost['author']) = is_array($forum['lastpost']) ? $forum['lastpost'] : explode("\t", $forum['lastpost']);
	$forum['folder'] = '<img src="'.IMGDIR.'/'.((isset($_DCOOKIE['fid'.$forum['fid']]) && $_DCOOKIE['fid'.$forum['fid']] > $lastvisit ? $_DCOOKIE['fid'.$forum['fid']] : $lastvisit) < $lastpost['dateline'] ? 'red_' : '').'forum.gif" alt="" />';

	if($lastpost['tid']) {
		$lastpost['dateline'] = gmdate("$dateformat $timeformat", $lastpost['dateline'] + $timeoffset * 3600);
		if($lastpost['author']) {
			$lastpost['author'] = '<a href="space.php?username='.rawurlencode($lastpost['author']).'">'.$lastpost['author'].'</a>';
		}
		$forum['lastpost'] = $lastpost;
	} else {
		$forum['lastpost'] = '';
	}

	$forum['moderators'] = moddisplay($forum['moderators'], $moddisplay, !empty($forum['inheritedmod'])).'&nbsp;';

	if(isset($forum['subforums'])) {
		$forum['subforums'] = implode(', ', $forum['subforums']);
	}

	return TRUE;
}

function forumselect($groupselectable = FALSE, $tableformat = 0) {
	global $_DCACHE, $discuz_uid, $groupid, $fid, $gid, $indexname;

	if(!isset($_DCACHE['forums'])) {
		require_once DISCUZ_ROOT.'./forumdata/cache/cache_forums.php';
	}

	$forumlist = $tableformat ? '' : '<optgroup label="&nbsp;">';
	foreach($_DCACHE['forums'] as $forum) {
		if($forum['type'] == 'group') {
			if($tableformat) {
				$forumlist .= '<tr><td class="popupmenu_option"><a'.($gid == $forum['fid'] ? ' class="bold"' : '').' href="'.$indexname.'?gid='.$forum['fid'].'">'.$forum['name'].'</a></td></tr>';
			} else {
				$forumlist .= $groupselectable ? '<option value="'.$forum['fid'].'">'.$forum['name'].'</option>' : '</optgroup><optgroup label="'.$forum['name'].'">';
			}
			$visible[$forum['fid']] = true;
		} elseif($forum['type'] == 'forum' && isset($visible[$forum['fup']]) && (!$forum['viewperm'] || ($forum['viewperm'] && forumperm($forum['viewperm'])) || strstr($forum['users'], "\t$discuz_uid\t"))) {
			if($tableformat) {
				$forumlist .= '<tr><td class="popupmenu_option">&nbsp; <a'.($fid == $forum['fid'] ? ' class="bold"' : '').' href="forumdisplay.php?fid='.$forum['fid'].'">&gt; '.$forum['name'].'</a></td></tr>';
			} else {
				$forumlist .= '<option value="'.$forum['fid'].'">&nbsp; &gt; '.$forum['name'].'</option>';
			}
			$visible[$forum['fid']] = true;
		} elseif($forum['type'] == 'sub' && isset($visible[$forum['fup']]) && (!$forum['viewperm'] || ($forum['viewperm'] && forumperm($forum['viewperm'])) || strstr($forum['users'], "\t$discuz_uid\t"))) {
			if($tableformat) {
				$forumlist .=  '<tr><td class="popupmenu_option">&nbsp; &nbsp; &nbsp; <a'.($fid == $forum['fid'] ? ' class="bold"' : '').' href="forumdisplay.php?fid='.$forum['fid'].'">&gt; '.$forum['name'].'</a></td></tr>';
			} else {
				$forumlist .= '<option value="'.$forum['fid'].'">&nbsp; &nbsp; &nbsp; &gt; '.$forum['name'].'</option>';
			}
		}
	}
	$forumlist .= $tableformat ? '' : '</optgroup>';
	$forumlist = $tableformat ? $forumlist : str_replace('<optgroup label="&nbsp;"></optgroup>', '', $forumlist);

	return $forumlist;
}

function visitedforums() {
	global $_DCACHE, $_DCOOKIE, $forum;

	$count = 0;
	$visitedforums = '';
	$fidarray = array($forum['fid']);
	foreach(explode('D', $_DCOOKIE['visitedfid']) as $fid) {
		if(isset($_DCACHE['forums'][$fid]) && !in_array($fid, $fidarray)) {
			$fidarray[] = $fid;
			if($fid != $forum['fid']) {
				$visitedforums .= '<option value="'.$fid.'">'.$_DCACHE['forums'][$fid]['name'].'</option>';
				if(++$count >= $GLOBALS['visitedforums']) {
					break;
				}

			}
		}
	}
	if(($visitedfid = implode('D', $fidarray)) != $_DCOOKIE['visitedfid']) {
		dsetcookie('visitedfid', $visitedfid, 2592000);
	}
	return $visitedforums;
}

function moddisplay($moderators, $type, $inherit = 0) {
	if($type == 'selectbox') {
		$modlist .= '<img src="images/common/online_moderator.gif" class="absmiddle" alt="" /><select '.($moderators ? '' : 'disabled').' name="modlist" style="width: 100px'.($inherit ? '; font-weight: bold"' : '').'">';

		if($moderators) {
			foreach(explode("\t", $moderators) as $moderator) {
				$modlist .= '<option value="'.rawurlencode($moderator).'">'.$moderator.'</option>';
			}
		} else {
			$modlist .= '<option></option>';
		}
		$modlist .= '</select>';
		return $modlist;
	} else {
		if($moderators) {
			$modlist = $comma = '';
			foreach(explode("\t", $moderators) as $moderator) {
				$modlist .= $comma.'<a href="space.php?username='.rawurlencode($moderator).'">'.($inherit ? $moderator : $moderator).'</a>';
				$comma = ', ';
			}
		} else {
			$modlist = '';
		}
		return $modlist;
	}
}

function getcacheinfo($tid) {
	global $timestamp, $cachethreadlife, $cachethreaddir;
	$tid = intval($tid);
	$cachethreaddir2 = DISCUZ_ROOT.'./'.$cachethreaddir;
	$cache = array('filemtime' => 0, 'filename' => '');
	$tidmd5 = substr(md5($tid), 3);
	$fulldir = $cachethreaddir2.'/'.$tidmd5[0].'/'.$tidmd5[1].'/'.$tidmd5[2].'/';
	$cache['filename'] = $fulldir.$tid.'.htm';
	if(file_exists($cache['filename'])) {
		$cache['filemtime'] = filemtime($cache['filename']);
	} else {
		if(!is_dir($fulldir)) {
			for($i=0; $i<3; $i++) {
				$cachethreaddir2 .= '/'.$tidmd5{$i};
				if(!is_dir($cachethreaddir2)) {
					@mkdir($cachethreaddir2, 0777);
					@touch($cachethreaddir2.'/index.htm');
				}
			}
		}
	}
	return $cache;
}

?>