<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: forumdisplay.php,v $
	$Revision: 1.69.2.4 $
	$Date: 2007/02/25 19:44:16 $
*/

define('CURSCRIPT', 'forumdisplay');

require_once './include/common.inc.php';
require_once DISCUZ_ROOT.'./include/forum.func.php';

$discuz_action = 2;

if($forum['redirect']) {
	dheader("Location: $forum[redirect]");
}

if(isset($showoldetails)) {
	switch($showoldetails) {
		case 'no': dsetcookie('onlineforum', 0, 86400 * 365); break;
		case 'yes': dsetcookie('onlineforum', 1, 86400 * 365); break;
	}
} else {
	$showoldetails = false;
}

if(!$forum['fid'] || $forum['type'] == 'group') {
	showmessage('forum_nonexistence', NULL, 'HALTED');
}

if($forum['type'] == 'forum') {
	$navigation = "&raquo; $forum[name]";
	$navtitle = strip_tags($forum['name']);
} else {
	$forumup = $_DCACHE['forums'][$forum['fup']]['name'];
	$navigation = "&raquo; <a href=\"forumdisplay.php?fid=$forum[fup]\">$forumup</a> &raquo; $forum[name]";
	$navtitle = strip_tags($forum['name']).' - '.strip_tags($forumup);
}
$rssstatus && $rsshead = '<link rel="alternate" type="application/rss+xml" title="'.$bbname.' - '.$navtitle.'" href="'.$boardurl.'rss.php?fid='.$fid.'&auth='.$rssauth.'">';
$navtitle .= ' - ';

if($forum['rules']) {
	if(empty($_COOKIE['discuz_collapse']) || strpos($_COOKIE['discuz_collapse'], 'rules_'.$forum['fid'].' ') === FALSE) {
		$rulescollapseimg = 'collapsed_no.gif';
		$collapserules = '';
	} else {
		$rulescollapseimg = 'collapsed_yes.gif';
		$collapserules = 'display: none';
	}
	$forum['rules'] = nl2br($forum['rules']);
}

if($forum['viewperm'] && !forumperm($forum['viewperm']) && !$forum['allowview']) {
	showmessage('forum_nopermission', NULL, 'NOPERM');
}

if($forum['password']) {
	if($action == 'pwverify') {
		if($pw != $forum['password']) {
			showmessage('forum_passwd_incorrect', NULL, 'HALTED');
		} else {
			dsetcookie('fidpw'.$fid, $pw);
			showmessage('forum_passwd_correct', "forumdisplay.php?fid=$fid");
		}
	} elseif($forum['password'] != $_DCOOKIE['fidpw'.$fid]) {
		include template('forumdisplay_passwd');
		exit();
	}
}

$moderatedby = moddisplay($forum['moderators'], 'forumdisplay');
$highlight = empty($highlight) ? '' : htmlspecialchars($highlight);
if($forum['autoclose']) {
	$closedby = $forum['autoclose'] > 0 ? 'dateline' : 'lastpost';
	$forum['autoclose'] = abs($forum['autoclose']) * 86400;
}

$subexists = 0;
foreach($_DCACHE['forums'] as $sub) {
	if($sub['type'] == 'sub' && $sub['fup'] == $fid && (!$hideprivate || !$sub['viewperm'] || forumperm($sub['viewperm']) || strstr($sub['users'], "\t$discuz_uid\t"))) {
		$subexists = 1;
		$sublist = array();
		$sql = $accessmasks ? "SELECT f.fid, f.fup, f.type, f.name, f.threads, f.posts, f.todayposts, f.lastpost, ff.description, ff.moderators, ff.icon, ff.viewperm, a.allowview FROM {$tablepre}forums f
						LEFT JOIN {$tablepre}forumfields ff ON ff.fid=f.fid
						LEFT JOIN {$tablepre}access a ON a.uid='$discuz_uid' AND a.fid=f.fid
						WHERE fup='$fid' AND status>0 AND type='sub' ORDER BY f.displayorder"
					: "SELECT f.fid, f.fup, f.type, f.name, f.threads, f.posts, f.todayposts, f.lastpost, ff.description, ff.moderators, ff.icon, ff.viewperm FROM {$tablepre}forums f
						LEFT JOIN {$tablepre}forumfields ff USING(fid)
						WHERE f.fup='$fid' AND f.status>0 AND f.type='sub' ORDER BY f.displayorder";
		$query = $db->query($sql);
		while($sub = $db->fetch_array($query)) {
			if(forum($sub)) {
				$sub['orderid'] = count($sublist);
				$sublist[] = $sub;
			}
		}
		break;
	}
}

if($subexists && $forum['forumcolumns']) {
	$forum['forumcolwidth'] = floor(100 / $forum['forumcolumns']).'%';
	$forum['subscount'] = count($sublist);
	$forum['endrows'] = '';
	if($colspan = $forum['subscount'] % $forum['forumcolumns']) {
		while(($forum['forumcolumns'] - $colspan) > 0) {
			$forum['endrows'] .= '<td class="altbg2"></td>';
			$colspan ++;
		}
		$forum['endrows'] .= '</tr>';
	}
}

if($forum['simple']) {
	include template('forumdisplay_simple');
	exit();
}

$page = max(1, intval($page));
$page = $threadmaxpages && $page > $threadmaxpages ? 1 : $page;
$start_limit = ($page - 1) * $tpp;

if($page == 1) {
	if($_DCACHE['announcements_forum']) {
		$announcement = $_DCACHE['announcements_forum'];
		$announcement['starttime'] = gmdate($dateformat, $announcement['starttime'] + ($timeoffset * 3600));
	} else {
		$announcement = NULL;
	}
}

$forumdisplayadd = $filteradd = '';
$specialtype = array('poll' => 1, 'trade' => 2, 'reward' => 3, 'activity' => 4);

if(isset($filter)) {
	if($filter == 'digest') {
		$forumdisplayadd .= '&amp;filter=digest';
		$filteradd = "AND digest>'0'";
	} elseif($filter == 'type' && $forum['threadtypes']['listable'] && $typeid && isset($forum['threadtypes']['types'][$typeid])) {
		$forumdisplayadd .= "&amp;filter=type&amp;typeid=$typeid";
		$filteradd = "AND typeid='$typeid'";
	} elseif(preg_match("/^\d+$/", $filter)) {
		$forumdisplayadd .= "&amp;filter=$filter";
		$filteradd = $filter ? "AND lastpost>='".($timestamp - $filter)."'" : '';
	} elseif(isset($specialtype[$filter])) {
		$forumdisplayadd .= "&amp;filter=$filter";
		$filteradd = "AND special='$specialtype[$filter]'";
	} else {
		$filter = '';
	}
} else {
	$filter = '';
}

isset($orderby) && in_array($orderby, array('dateline', 'replies', 'views')) ? $forumdisplayadd .= "&amp;orderby=$orderby" : $orderby = 'lastpost';
isset($ascdesc) && $ascdesc == 'ASC' ? $forumdisplayadd .= '&amp;ascdesc=ASC' : $ascdesc = 'DESC';

if($whosonlinestatus == 2 || $whosonlinestatus == 3) {
	$whosonlinestatus = 1;
	$onlineinfo = explode("\t", $onlinerecord);
	$detailstatus = $showoldetails == 'yes' || (((!isset($_DCOOKIE['onlineforum']) && !$whosonline_contract) || $_DCOOKIE['onlineforum']) && $onlineinfo[0] < 500 && !$showoldetails);

	if($detailstatus) {
		updatesession();
		@include language('actions');
		$whosonline = array();
		$forumname = strip_tags($forum['name']);
		$guestwhere = isset($_DCACHE['onlinelist'][7]) ? '' : "uid>'0' AND";

		$query = $db->query("SELECT uid, groupid, username, invisible, lastactivity, action FROM {$tablepre}sessions WHERE $guestwhere fid='$fid' AND invisible='0'");
		if($db->num_rows($query)) {
			$whosonlinestatus = 1;
			while($online = $db->fetch_array($query)) {
				if($online['uid']) {
					$online['icon'] = isset($_DCACHE['onlinelist'][$online['groupid']]) ? $_DCACHE['onlinelist'][$online['groupid']] : $_DCACHE['onlinelist'][0];
				} else {
					$online['icon'] = $_DCACHE['onlinelist'][7];
					$online['username'] = 'Guest';
				}
				$online['action'] = $actioncode[$online['action']];
				$online['lastactivity'] = gmdate($timeformat, $online['lastactivity'] + ($timeoffset * 3600));
				$whosonline[] = $online;
			}
		}
		unset($online);
	}
} else {
	$whosonlinestatus = 0;
}

$pmlist = array();
$announcepm = 0;
if($_DCACHE['pmlist']) {
	$readapmids = !empty($_DCOOKIE['readapmid']) ? explode('D', $_DCOOKIE['readapmid']) : array();
	foreach($_DCACHE['pmlist'] as $pm) {
		if($discuz_uid && (empty($pm['groups']) || in_array($groupid, $pm['groups']))) {
			if(!in_array($pm['id'], $readapmids)) {
				$pm['announce'] = TRUE;
				$pmlist[] = $pm;
				$announcepm++;
			}
		}
	}
}
if($discuz_uid && $newpm) {
	require_once DISCUZ_ROOT.'./include/pmprompt.inc.php';
}

if(empty($filter)) {
	$threadcount = $forum['threads'];
} else {
	$query = $db->query("SELECT COUNT(*) FROM {$tablepre}threads WHERE fid='$fid' $filteradd AND displayorder>='0'");
	$threadcount = $db->result($query, 0);
}
if($globalstick) {
	$thisgid = $forum['type'] == 'forum' ? $forum['fup'] : $_DCACHE['forums'][$forum['fup']]['fup'];
	$stickytids = $_DCACHE['globalstick']['global']['tids'].(empty($_DCACHE['globalstick']['categories'][$thisgid]['count']) ? '' : ','.$_DCACHE['globalstick']['categories'][$thisgid]['tids']);

	$stickycount = $_DCACHE['globalstick']['global']['count'] + $_DCACHE['globalstick']['categories'][$thisgid]['count'];
} else {
	$thisgid = $stickycount = $stickytids = 0;
}

$filterbool = !empty($filter) && in_array($filter, array('digest', 'type', 'activity', 'poll', 'trade', 'reward'));
$threadcount += $filterbool ? 0 : $stickycount;
$multipage = multi($threadcount, $tpp, $page, "forumdisplay.php?fid=$fid$forumdisplayadd", $threadmaxpages);
$extra = rawurlencode("page=$page$forumdisplayadd");

$separatepos = 0;
$threadlist = array();
$colorarray = array('', 'red', 'orange', 'yellow', 'green', 'cyan', 'blue', 'purple', 'gray');

$displayorderadd = !$filterbool && $stickycount ? 't.displayorder IN (0, 1)' : 't.displayorder>=0';

if(($start_limit && $start_limit > $stickycount) || !$stickycount || $filterbool) {

	$querysticky = '';
	$query = $db->query("SELECT t.* FROM {$tablepre}threads t
		WHERE t.fid='$fid' $filteradd AND $displayorderadd
		ORDER BY t.displayorder DESC, t.$orderby $ascdesc
		LIMIT ".($filterbool ? $start_limit : $start_limit - $stickycount).", $tpp");

} else {

	$querysticky = $db->query("SELECT t.* FROM {$tablepre}threads t $dotadd2
		WHERE t.tid IN ($stickytids) AND t.displayorder IN (2, 3)
		ORDER BY displayorder DESC, $orderby $ascdesc
		LIMIT $start_limit, ".($stickycount - $start_limit < $tpp ? $stickycount - $start_limit : $tpp));

	if($tpp - $stickycount + $start_limit > 0) {
		$query = $db->query("SELECT t.* FROM {$tablepre}threads t $dotadd2
			WHERE t.fid='$fid' $filteradd AND $displayorderadd
			ORDER BY displayorder DESC, $orderby $ascdesc
			LIMIT ".($tpp - $stickycount + $start_limit));
	} else {
		$query = '';
	}

}

$ppp = $forum['threadcaches'] && !$discuz_uid ? $_DCACHE['settings']['postperpage'] : $ppp;
$iscircle = $supe['status'] && $supe['circlestatus'] && $forum['status'] == 2 ? 1 : 0;
$sgids = array();

while(($querysticky && $thread = $db->fetch_array($querysticky)) || ($query && $thread = $db->fetch_array($query))) {
	$thread['icon'] = isset($_DCACHE['icons'][$thread['iconid']]) ? '<img src="'.SMDIR.'/'.$_DCACHE['icons'][$thread['iconid']].'" alt="" />' : '&nbsp;';
	$thread['lastposterenc'] = rawurlencode($thread['lastposter']);

	$thread['typeid'] = $thread['typeid'] && !empty($forum['threadtypes']['prefix']) && isset($forum['threadtypes']['types'][$thread['typeid']]) ?
		'['.$forum['threadtypes']['types'][$thread['typeid']].'] ' : '';

	$thread['multipage'] = '';
	$topicposts = $thread['replies'] + 1;
	if($topicposts > $ppp) {
		$pagelinks = '';
		$topicpages = ceil($topicposts / $ppp);
		for($i = 1; $i <= 6 && $i <= $topicpages; $i++) {
			$pagelinks .= "<a href=\"viewthread.php?tid=$thread[tid]&amp;extra=$extra&amp;page=$i\">$i</a> ";
		}
		if($topicpages > 6) {
			$pagelinks .= " .. <a href=\"viewthread.php?tid=$thread[tid]&amp;extra=$extra&amp;page=$topicpages\">$topicpages</a> ";
		}
		$thread['multipage'] = ' &nbsp;<img src="'.IMGDIR.'/multipage.gif"  border="0" alt="" /> '.$pagelinks;
	}

	if($thread['highlight']) {
		$string = sprintf('%02d', $thread['highlight']);
		$stylestr = sprintf('%03b', $string[0]);

		$thread['highlight'] = ' style="';
		$thread['highlight'] .= $stylestr[0] ? 'font-weight: bold;' : '';
		$thread['highlight'] .= $stylestr[1] ? 'font-style: italic;' : '';
		$thread['highlight'] .= $stylestr[2] ? 'text-decoration: underline;' : '';
		$thread['highlight'] .= $string[1] ? 'color: '.$colorarray[$string[1]] : '';
		$thread['highlight'] .= '"';
	} else {
		$thread['highlight'] = '';
	}

	$thread['moved'] = 0;
	if($thread['closed'] || ($forum['autoclose'] && $timestamp - $thread[$closedby] > $forum['autoclose'])) {
		$thread['new'] = 0;
		if($thread['closed'] > 1) {
			$thread['moved'] = $thread['tid'];
			$thread['tid'] = $thread['closed'];
			$thread['replies'] = '-';
			$thread['views'] = '-';
		}
		$thread['folder'] = 'lock_folder.gif';
	} else {
		$thread['folder'] = 'folder.gif';
		if($lastvisit < $thread['lastpost'] && (empty($_DCOOKIE['oldtopics']) || strpos($_DCOOKIE['oldtopics'], 'D'.$thread['tid'].'D') === FALSE)) {
			$thread['new'] = 1;
			$thread['folder'] = 'red_'.$thread['folder'];
		} else {
			$thread['new'] = 0;
		}
		if($thread['replies'] > $thread['views']) {
			$thread['views'] = $thread['replies'];
		}
		if($thread['replies'] >= $hottopic) {
			$thread['folder'] = 'hot_'.$thread['folder'];
		}
		if($dotfolders && $thread['dotauthor'] == $discuz_uid && $discuz_uid) {
			$thread['folder'] = 'dot_'.$thread['folder'];
		}
	}

	$thread['dateline'] = gmdate($dateformat, $thread['dateline'] + $timeoffset * 3600);
	$thread['lastpost'] = gmdate("$dateformat $timeformat", $thread['lastpost'] + $timeoffset * 3600);

	if($thread['displayorder'] > 0) {
		$separatepos++;
	}

	$iscircle && $thread['sgid'] && $sgids[] = $thread['sgid'];
	$threadlist[] = $thread;

}

$separatepos = $separatepos ? $separatepos + 1 : ($announcement ? 1 : 0);

$check = array();
$check[$filter] = $check[$orderby] = $check[$ascdesc] = 'selected="selected"';

$visitedforums = $visitedforums ? visitedforums() : '';
$forumselect = $forummenu = '';
if($forumjump && empty($jsmenu[1])) {
	$forumselect = forumselect();
}
$typeselect = typeselect($typeid);

$usesigcheck = $discuz_uid && $sigstatus ? 'checked' : '';
$allowpost = (!$forum['postperm'] && $allowpost) || ($forum['postperm'] && forumperm($forum['postperm'])) || !empty($forum['allowpost']);

$showpoll = $showtrade = $showreward = $showactivity = 0;
if($forum['allowpostspecial']) {
	$showpoll = $forum['allowpostspecial'] & 1;
	$showtrade = $forum['allowpostspecial'] & 2;
	$showreward = isset($extcredits[$creditstrans]) && ($forum['allowpostspecial'] & 4);
	$showactivity = $forum['allowpostspecial'] & 8;
}

if($allowpost) {
	$allowpostpoll = $allowpostpoll && $showpoll;
	$allowposttrade = $allowposttrade && $showtrade;
	$allowpostreward = $allowpostreward && $showreward;
	$allowpostactivity = $allowpostactivity && $showactivity;
}

$searchboxstatus = substr(sprintf('%03b', $qihoo_searchbox), -2, 1);

$forumselect = $forummenu = $smmultipage = '';

if($fastpost && $allowpost && $_DCACHE['smiliesnum'] > $smcols * $smrows) {
	$smpage = max(1, intval($_COOKIE['smpage']));
	$smmultipage = multi($_DCACHE['smiliesnum'], $smcols * $smrows, 1, '###', 0, 4, 1, 'getSmilies');
}

if($forumjump) {
	if($jsmenu[1]) {
		$forummenu = forumselect(FALSE, 1);
	} else {
		$forumselect = forumselect();
	}
}

if($iscircle) {
        require_once DISCUZ_ROOT.'./include/supesite_circle.inc.php';
}

include template('forumdisplay');

?>