<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: logs.inc.php,v $
	$Revision: 1.23.2.8 $
	$Date: 2007/03/12 13:20:19 $
*/

if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
        exit('Access Denied');
}

cpheader();

$lpp = empty($lpp) ? 50 : $lpp;

if(!in_array($action, array('illegallog', 'ratelog', 'modslog', 'medalslog', 'banlog', 'cplog', 'errorlog'))) {
	cpmsg('undefined_action');
}

$file = $action;
$yearmonth = gmdate('Ym', $timestamp + $_DCACHE['settings']['timeoffset'] * 3600);
$logdir = DISCUZ_ROOT.'./forumdata/logs/';
$logfile = $logdir.$yearmonth.'_'.$file.'.php';

($logs = (array)@file($logfile)) && @array_pop($logs);
$filesize = @filesize($logfile);

if($filesize < 500000) {
	$dir = opendir($logdir);
	$length = strlen($file);
	$maxid = $id = 0;
	while($entry = readdir($dir)) {
		if(strexists($entry, $yearmonth.'_'.$file)) {
			$id = intval(substr($entry, $length + 8));
			$id > $maxid && $maxid = $id;
		}
	}
	closedir($dir);

	if($maxid) {
		$filename2 = $logdir.$yearmonth.'_'.$file.'_'.$maxid.'.php';
	} else {
		$lastyearmonth = gmdate('Ym', $timestamp - 86400 * 28 + $_DCACHE['settings']['timeoffset'] * 3600);
		$filename2 = $logdir.$lastyearmonth.'_'.$file.'.php';
	}

	if(file_exists($filename2) && $logs2 = @file($filename2)) {
		array_pop($logs2);
		$logs = array_merge($logs, $logs2);
	}
}

$page = max(1, intval($page));
$start = ($page - 1) * $lpp;
$logs = array_reverse($logs);

if(empty($keyword)) {
	$num = count($logs);
	$multipage = multi($num, $lpp, $page, "admincp.php?action=$action&lpp=$lpp");
	$logs = array_slice($logs, $start, $lpp);

} else {
	foreach($logs as $key => $value) {
		if(strpos($value, $keyword) === FALSE) {
			unset($logs[$key]);
		}
	}
	$multipage = '';
}

$lognames = array
	(
	'illegallog'	=> 'logs_passwd',
	'ratelog'	=> 'logs_rating',
	'modslog'	=> 'logs_moderate',
	'medalslog'	=> 'logs_medal',
	'banlog'	=> 'logs_banned',
	'cplog'		=> 'logs_cp',
	'errorlog'	=> 'logs_error'
	);

shownav($lang[$lognames[$action]]);

?>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="tableborder">
<tr class="header"><td colspan="3"><?=$lang[$lognames[$action]]?></td></tr>
<form method="post" action="admincp.php?action=<?=$action?>">
<input type="hidden" name="formhash" value="<?=FORMHASH?>">
<tr class="altbg2"><td width="25%"><?=$lang['logs_lpp']?></td>
<td width="55%"><input type="text" name="lpp" size="40" maxlength="40" value="<?=$lpp?>"></td>
<td width="20%"><input class="button" type="submit" value="<?=$lang['submit']?>"></td></tr>
</form>

<form method="post" action="admincp.php?action=<?=$action?>">
<input type="hidden" name="formhash" value="<?=FORMHASH?>">
<tr class="altbg2"><td><?=$lang['logs_search']?></td><td><input type="text" name="keyword" size="40" value="<?=dhtmlspecialchars($keyword)?>"></td>
<td><input class="button" type="submit" value="<?=$lang['submit']?>"></td></tr>
</form>
</table><br>

<?=$multipage?>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="tableborder">
<?

$usergroup = array();
if(in_array($action, array('ratelog', 'modslog', 'banlog', 'cplog'))) {
	$query = $db->query("SELECT groupid, grouptitle FROM {$tablepre}usergroups");
	while($group = $db->fetch_array($query)) {
		$usergroup[$group['groupid']] = $group['grouptitle'];
	}
}

if($action == 'illegallog') {

	echo "<tr class=\"header\">".
		"<td>$lang[logs_passwd_username]</td>".
		"<td>$lang[logs_passwd_password]</td>".
		"<td>$lang[logs_passwd_security]</td>".
		"<td>$lang[ip]</td>".
		"<td>$lang[time]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		if(strtolower($log[2]) == strtolower($discuz_userss)) {
			$log[2] = "<b>$log[2]</b>";
		}
		$log[5] = $allowviewip ? $log[5] : '-';

		echo "<tr align=\"center\"><td class=\"altbg1\">$log[2]</td>\n".
			"<td class=\"altbg2\">$log[3]</td><td class=\"altbg1\">$log[4]</td>\n".
			"<td class=\"altbg2\">$log[5]</td><td class=\"altbg1\">$log[1]</td></tr>\n";
	}

} elseif($action == 'ratelog') {

	echo "<tr class=\"header\">".
		"<td width=\"13%\">$lang[username]</td>".
		"<td width=\"12%\">$lang[usergroup]</td>".
		"<td width=\"12%\">$lang[time]</td>".
		"<td width=\"13%\">$lang[logs_rating_username]</td>".
		"<td width=\"14%\">$lang[logs_rating_rating]</td>".
		"<td width=\"23%\">$lang[subject]</td>".
		"<td width=\"13%\">$lang[reason]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = "<a href=\"viewpro.php?username=".rawurlencode($log[2])."\" target=\"_blank\">$log[2]</a>";
		$log[3] = $usergroup[$log[3]];
		if($log[4] == $discuz_userss) {
			$log[4] = "<b>$log[4]</b>";
		}
		$log[4] = "<a href=\"viewpro.php?username=".rawurlencode($log[4])."\" target=\"_blank\">$log[4]</a>";
		$log[6] = $extcredits[$log[5]]['title'].' '.($log[6] < 0 ? "<b>$log[6]</b>" : "+$log[6]").' '.$extcredits[$log[5]]['unit'];
		$log[7] = $log[7] ? "<a href=\"./viewthread.php?tid=$log[7]\" target=\"_blank\" title=\"$log[8]\">".cutstr($log[8], 20)."</a>" : "<i>$lang[logs_rating_manual]</i>";

		echo "<tr align=\"center\"><td class=\"altbg1\">$log[2]</a></td><td class=\"altbg2\">$log[3]</td>\n".
			"<td class=\"altbg1\">$log[1]</td><td class=\"altbg2\">$log[4]</td>\n".
			"<td class=\"altbg1\">".(trim($log[10]) == 'D' ? $lang['logs_rating_delete'] : '')."$log[6]</td><td class=\"altbg2\">$log[7]</td>\n".
			"<td class=\"altbg1\">$log[9]</td></tr>\n";
	}

} elseif($action == 'modslog') {

	include language('modactions');

	echo "<tr class=\"header\">".
		"<td width=\"13%\">$lang[operator]</td>".
		"<td width=\"10%\">$lang[usergroup]</td>".
		"<td width=\"10%\">$lang[ip]</td>".
		"<td width=\"16%\">$lang[time]</td>".
		"<td width=\"12%\">$lang[forum]</td>".
		"<td width=\"19%\">$lang[thread]</td>".
		"<td width=\"10%\">$lang[action]</td>".
		"<td width=\"10%\">$lang[reason]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = stripslashes($log[2]);
		$log[3] = $usergroup[$log[3]];
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[6] = "<a href=\"./forumdisplay.php?fid=$log[5]\" target=\"_blank\">$log[6]</a>";
		$log[8] = "<a href=\"./viewthread.php?tid=$log[7]\" target=\"_blank\" title=\"$log[8]\">".cutstr($log[8], 15)."</a>";
		$log[9] = $modactioncode[trim($log[9])];

		echo "<tr align=\"center\"><td class=\"altbg1\"><a href=\"viewpro.php?username=".rawurlencode($log[2])."\" target=\"_blank\">".($log[2] != $discuz_userss ? "<b>$log[2]</b>" : $log[2])."</td>\n".
			"<td class=\"altbg2\">$log[3]</td><td class=\"altbg1\">$log[4]</td>\n".
			"<td class=\"altbg2\">$log[1]</td><td class=\"altbg1\">$log[6]</td>\n".
			"<td class=\"altbg2\">$log[8]</td><td class=\"altbg1\">$log[9]</td>\n".
			"<td class=\"altbg2\">$log[10]</td></tr>\n";
	}

} elseif($action == 'medalslog') {

	$medalsarray = array();
	$query = $db->query("SELECT * FROM {$tablepre}medals WHERE available>'0'");
	while($medal = $db->fetch_array($query)) {
		$medalsarray[$medal['medalid']] = "<img src=\"images/common/$medal[image]\" border=\"0\" align=\"absmiddle\"> $medal[name]";
	}

	echo "<tr class=\"header\">".
		"<td width=\"13%\">$lang[operator]</td>".
		"<td width=\"13%\">$lang[ip]</td>".
		"<td width=\"13%\">$lang[time]</td>".
		"<td width=\"13%\">$lang[username]</td>".
		"<td width=\"7%\">$lang[action]</td>".
		"<td width=\"18%\">$lang[logs_medal_name]</td>".
		"<td width=\"23%\">$lang[reason]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[3] = $allowviewip ? $log[3] : '-';
		$log[4] = "<a href=\"viewpro.php?username=".rawurlencode($log[4])."\" target=\"_blank\">$log[4]</a>";
		$log[5] = isset($medalsarray[$log[5]]) ? $medalsarray[$log[5]] : $lang['members_edit_medals_unavailable'];
		$log[6] = $lang['members_edit_medals_'.$log[6]];

		echo "<tr align=\"center\"><td class=\"altbg1\"><a href=\"viewpro.php?username=".rawurlencode($log[2])."\" target=\"_blank\">".($log[2] != $discuz_userss ? "<b>$log[2]</b>" : $log[2])."</td>\n".
			"<td class=\"altbg2\">$log[3]</td><td class=\"altbg1\">$log[1]</td>\n".
			"<td class=\"altbg2\">$log[4]</td><td class=\"altbg1\">$log[6]</td>\n".
			"<td class=\"altbg2\">$log[5]</td><td class=\"altbg2\">$log[7]</td></tr>\n";
	}

} elseif($action == 'banlog') {

	echo "<tr class=\"header\">".
		"<td width=\"10%\">$lang[operator]</td>".
		"<td width=\"10%\">$lang[usergroup]</td>".
		"<td width=\"10%\">$lang[ip]</td>".
		"<td width=\"10%\">$lang[time]</td>".
		"<td width=\"10%\">$lang[username]</td>".
		"<td width=\"5%\">$lang[operation]</td>".
		"<td width=\"20%\">$lang[logs_banned_group]</td>".
		"<td width=\"8%\">$lang[validity]</td>".
		"<td width=\"17%\">$lang[reason]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[3] = $usergroup[$log[3]];
		$log[8] = trim($log[8]) ? gmdate('y-n-j', $log[8] + $timeoffset * 3600) : '';

		echo "<tr align=\"center\"><td class=\"altbg1\"><a href=\"viewpro.php?username=".rawurlencode($log[2])."\" target=\"_blank\">$log[2]</td>\n".
			"<td class=\"altbg2\">$log[3]</td><td class=\"altbg1\">$log[4]</td>\n".
			"<td class=\"altbg2\">$log[1]</td><td class=\"altbg1\"><a href=\"viewpro.php?username=".rawurlencode($log[5])."\" target=\"_blank\">$log[5]</a></td>\n".
			"<td class=\"altbg2\">".(in_array($log[6], array(4, 5)) && !in_array($log[7], array(4, 5)) ? '<i>'.$lang['logs_banned_unban'].'</i>' : '<b>'.$lang['logs_banned_ban'].'</b>')."</td>".
			"<td class=\"altbg1\">{$usergroup[$log[6]]} / {$usergroup[$log[7]]}</td><td class=\"altbg1\">$log[8]</td>\n".
			"<td class=\"altbg1\">$log[9]</td></tr>\n";
	}

} elseif($action == 'cplog') {

	echo "<tr class=\"header\">".
		"<td width=\"10%\">$lang[operator]</td>".
		"<td width=\"10%\">$lang[usergroup]</td>".
		"<td width=\"10%\">$lang[ip]</td>".
		"<td width=\"18%\">$lang[time]</td>".
		"<td width=\"15%\">$lang[action]</td>".
		"<td width=\"37%\">$lang[other]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$log[2] = stripslashes($log[2]);
		$log[3] = $usergroup[$log[3]];
		$log[4] = $allowviewip ? $log[4] : '-';
		$log[5] = $lang['cplog_action_'.rtrim($log[5])];
		echo "<tr align=\"center\"><td class=\"altbg1\"><a href=\"viewpro.php?username=".rawurlencode($log[2])."\" target=\"_blank\">".($log[2] != $discuz_userss ? "<b>$log[2]</b>" : $log[2])."</a></td>\n".
			"<td class=\"altbg2\">$log[3]</td><td class=\"altbg1\">$log[4]</td>\n".
			"<td class=\"altbg2\">$log[1]</td><td class=\"altbg1\">$log[5]</td>\n".
			"<td class=\"altbg2\">$log[6]&nbsp;</td></tr>\n";
	}

} elseif($action == 'errorlog') {

	echo "<tr class=\"header\">".
		"<td width=\"8%\">$lang[type]</td>".
		"<td width=\"15%\">$lang[username]</td>".
		"<td width=\"15%\">$lang[time]</td>".
		"<td width=\"62%\">$lang[message]</td>".
		"</tr>\n";

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = gmdate('y-n-j H:i', $log[1] + $timeoffset * 3600);
		$tmp = explode('<br>', $log[3]);
		$username = $tmp[0];
		$ip = $tmp[1];

		echo "<tr align=\"center\"><td class=\"altbg1\">$log[2]</td>\n".
			"<td class=\"altbg2\"><a href=\"viewpro.php?username=".rawurlencode($username)."\" target=\"_blank\">$username</a><br>$ip</td><td class=\"altbg1\">$log[1]</td>\n".
			"<td class=\"altbg2\">$log[4]</td></tr>\n";
	}

}
?>
</table>

<?=$multipage?>