<?php

/*
	[Discuz!] (C)2001-2006 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$RCSfile: checktools.inc.php,v $
	$Revision: 1.8.2.4 $
	$Date: 2007/03/09 21:36:17 $
*/

if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
        exit('Access Denied');
}

cpheader();

if(!isfounder()) cpmsg('noaccess');

if($action == 'filecheck') {

	shownav('menu_tools_filecheck');
	if(!isset($start)) {
		cpmsg('filecheck_checking', 'admincp.php?action=filecheck&start=yes');
	} else {
		if(!$discuzfiles = @file('admin/discuzfiles.md5')) {
			cpmsg('filecheck_nofound_md5file');
		}
		showtips('filecheck_tips');

		$md5data = array();
		$cachelist = checkcachefiles('forumdata/cache/');
		checkfiles('./', '\.php', 0, 'config.inc.php,mail_config.inc.php');
		checkfiles('include/', '\.php|\.htm|\.js');
		checkfiles('templates/default/', '\.php|\.htm');
		checkfiles('wap/', '\.php');
		checkfiles('archiver/', '\.php');
		checkfiles('api/', '\.php');
		checkfiles('plugins/', '\.php');
		checkfiles('admin/', '\.php');


		foreach($discuzfiles as $line) {
			$file = trim(substr($line, 34));
			$md5datanew[$file] = substr($line, 0, 32);
			if($md5datanew[$file] != $md5data[$file]) {
				$modifylist[$file] = $md5data[$file];
			}
			$md5datanew[$file] = $md5data[$file];
		}

		$weekbefore = $timestamp - 604800;
		$addlist = @array_merge(@array_diff_assoc($md5data, $md5datanew), $cachelist[2]);
		$dellist = @array_diff_assoc($md5datanew, $md5data);
		$modifylist = @array_merge(@array_diff_assoc($modifylist, $dellist), $cachelist[1]);
		$showlist = @array_merge($md5data, $md5datanew, $cachelist[0]);

		$dirlist = $dirlog = array();
		foreach($showlist as $file => $md5) {
			$dir = dirname($file);
			$filelist = '<tr><td class="altbg1">'.basename($file).'</td>';
			if(file_exists($file)) {
				$filemtime = filemtime($file);
				$filemtime = $filemtime > $weekbefore ? '<b>'.date("$dateformat $timeformat", $filemtime).'</b>' : date("$dateformat $timeformat", $filemtime);
				$filelist .= '<td class="altbg2" style="text-align:right">'.number_format(filesize($file)).' Bytes&nbsp;&nbsp;</td><td class="altbg1">'.$filemtime.'</td>';
			} else {
				$filelist .= '<td class="altbg2"></td><td class="altbg1"></td>';
			}
			if(@array_key_exists($file, $modifylist)) {
				$filelist .= '<td class="altbg2"><font color="#FF0000">'.$lang['filecheck_modify'].'</font></td></tr>';
				$dirlog[$dir]['modify']++;
			} elseif(@array_key_exists($file, $dellist)) {
				$filelist .= '<td class="altbg2"><font color="#0000FF">'.$lang['filecheck_delete'].'</font></td></tr>';
				$dirlog[$dir]['del']++;
			} elseif(@array_key_exists($file, $addlist)) {
				$filelist .= '<td class="altbg2"><font color="#00FF00">'.$lang['filecheck_unknown'].'</font></td></tr>';
				$dirlog[$dir]['add']++;
			} else {
				$filelist .= '<td class="altbg2">'.$lang['filecheck_check_ok'].'</td></tr>';
			}
			$dirlist[$dir] .= $filelist;
		}
	}

?>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="tableborder">
<tr class="header"><td colspan="4"><?=$lang['filecheck_completed']?></td></tr>
<tr><td colspan="4"><?=$lang['filecheck_modify'].': '.count($modifylist).' &nbsp; '.$lang['filecheck_delete'].': '.count($dellist).' &nbsp; '.$lang['filecheck_unknown'].': '.count($addlist)?></td></tr>
<?

foreach($dirlist as $dirname => $filelist) {
	echo '<tr class="header"><td>'.$dirname.'/</td><td colspan="3" style="text-align:right">'.
		($dirlog[$dirname]['modify'] ? $lang['filecheck_modify'].': '.$dirlog[$dirname]['modify'].' &nbsp; ' : '').
		($dirlog[$dirname]['del'] ? $lang['filecheck_delete'].': '.$dirlog[$dirname]['del'].' &nbsp; ' : '').
		($dirlog[$dirname]['add'] ? $lang['filecheck_unknown'].': '.$dirlog[$dirname]['add'].' &nbsp; ' : '').
		'</td><tr><tr class="category"><td>'.$lang['filename'].'</td><td style="text-align:right">'.$lang['size'].'&nbsp;&nbsp;</td><td>'.$lang['filecheck_filemtime'].'</td><td>'.$lang['filecheck_status'].'</td></tr>'.$filelist;
}

?>
</td></tr></table>
<?

} elseif($action == 'dbcheck') {

	shownav('menu_tools_dbcheck');
	if(!isset($start)) {
		cpmsg('dbcheck_checking', 'admincp.php?action=dbcheck&start=yes');
	} else {

		if(!file_exists('admin/discuzdb.md5')) {
			cpmsg('dbcheck_nofound_md5file');
		}
		$fp = fopen('admin/discuzdb.md5', "rb");
		$discuzdb = fread($fp, filesize('admin/discuzdb.md5'));
		fclose($fp);
		$dbmd5 = substr($discuzdb, 0, 32);
		$discuzdb = unserialize(substr($discuzdb, 34));
		$discuzdb_extra = $discuzdb[1];
		$discuzdb = $discuzdb[0];

		if(submitcheck('repairsubmit') && !empty($repair) && is_array($repair)) {
			$error = '';$count = $errorcount = 0;
			foreach($repair as $value) {
				list($r_table, $r_field, $option) = explode('|', $value);
				$field = $discuzdb[$r_table][$r_field];
				$altersql = '`'.$field['Field'].'` '.$field['Type'];
				$altersql .= $field['Null'] == 'NO' ? ' NOT NULL' : '';
				$altersql .= $discuzdb_extra[$r_table][$r_field]['Default'] != '' ? ' default \''.$discuzdb_extra[$r_table][$r_field]['Default'].'\'' : '';
				$altersql = $option == 'modify' ? "ALTER TABLE `$tablepre$r_table` MODIFY COLUMN ".$altersql : "ALTER TABLE `$tablepre$r_table` ADD COLUMN ".$altersql;
				$db->query($altersql, 'SILENT');
				if($sqlerror = $db->error()) {
					$errorcount++;
					$error .= $sqlerror.'<br><br>';
				} else {
					$count++;
				}
			}
			if($errorcount) {
				cpmsg('dbcheck_repair_error');
			} else {
				cpmsg('dbcheck_repair_completed', 'admincp.php?action=dbcheck');
			}
		}

		$discuzdbnew = $deltables = $missingtables = $charseterror = array();
		foreach($discuzdb as $dbtable => $fields) {
			if($fieldsquery = $db->query("SHOW FIELDS FROM $tablepre$dbtable", 'SILENT')) {
				while($fields = $db->fetch_array($fieldsquery)) {
					$r = '/^'.$tablepre.'/';
					$cuttable = preg_replace($r, '', $dbtable);
					$discuzdbnew[$cuttable][$fields['Field']]['Field'] = $fields['Field'];
					if($db->version() < '4.1' && $cuttable == 'sessions' && $fields['Field'] == 'sid') {
						$fields['Type'] = str_replace(' binary', '', $fields['Type']);
					}
					$discuzdbnew[$cuttable][$fields['Field']]['Type'] = $fields['Type'];
					$discuzdbnew[$cuttable][$fields['Field']]['Null'] = $fields['Null'] == '' ? 'NO' : $fields['Null'];
				}
				ksort($discuzdbnew[$cuttable]);
			} else {
				$missingtables[] = $tablepre.$dbtable;
			}
		}

		if($db->version() > '4.1') {
			include './config.inc.php';
			$dbcharset = empty($dbcharset) ? $charset : $dbcharset;
			$dbcharset = strtoupper($dbcharset) == 'UTF-8' ? 'UTF8' : strtoupper($dbcharset);
			$query = $db->query("SHOW TABLE STATUS LIKE '$tablepre%'");
			while($tables = $db->fetch_array($query)) {
				$r = '/^'.$tablepre.'/';
				$cuttable = preg_replace($r, '', $tables['Name']);
				$tabledbcharset = substr($tables['Collation'], 0, strpos($tables['Collation'], '_'));
				if($dbcharset != strtoupper($tabledbcharset)) {
					$charseterror[] = "$cuttable($tabledbcharset)";
				}
			}
		}

		$dbmd5new = md5(serialize($discuzdbnew));

		if($dbmd5 == $dbmd5new && empty($charseterror)) {
			cpmsg('dbcheck_ok');
		}

		showtips('dbcheck_tips');

?>
<form method="post" action="admincp.php?action=dbcheck&start=yes">
<input type="hidden" name="formhash" value="<?=FORMHASH?>">
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="tableborder">
<?

		$haverepair = FALSE;
		foreach($discuzdb as $dbtable => $fields) {
			$addlist = $modifylist = $dellist = array();
			if($fields != $discuzdbnew[$dbtable]) {
				foreach($discuzdb[$dbtable] as $key => $value) {
					if(is_array($missingtables) && in_array($tablepre.$dbtable, $missingtables)) {
					} elseif(!isset($discuzdbnew[$dbtable][$key])) {
						$dellist[] = $value;
					} elseif($value != $discuzdbnew[$dbtable][$key]) {
						$modifylist[] = $value;
					}
				}
				if(is_array($discuzdbnew[$dbtable])) {
					foreach($discuzdbnew[$dbtable] as $key => $value) {
						if(!isset($discuzdb[$dbtable][$key])) {
							$addlist[] = $value;
						}
					}
				}
			}

			if($modifylist || $dellist || $addlist) {
				echo "<tr class=\"header\"><td colspan=\"2\">$tablepre$dbtable</td></tr>";
				echo "<tr class=\"category\"><td>$lang[dbcheck_field]</td><td>$lang[dbcheck_status]</td></tr>";

				foreach($modifylist as $value) {
					echo "<tr><td class=\"altbg1\"><input name=\"repair[]\" class=\"checkbox\" type=\"checkbox\" value=\"$dbtable|$value[Field]|modify\"> <b>".$value['Field']."</b> ".$discuzdbnew[$dbtable][$value['Field']]['Type'].($discuzdbnew[$dbtable][$value['Field']]['Null'] == 'NO' ? ' NOT NULL' : '')." >>> ".$value['Type'].($value['Null'] == 'NO' ? ' NOT NULL' : '')."</td><td class=\"altbg2\">".
						"<font color=\"#FF0000\">$lang[dbcheck_modify]</font></td></tr>";
					$haverepair = TRUE;
				}
				foreach($dellist as $value) {
					echo "<tr><td class=\"altbg1\"><input name=\"repair[]\" class=\"checkbox\" type=\"checkbox\" value=\"$dbtable|$value[Field]|add\"> <b>".$value['Field']."</b> ".$value['Type'].($value['Null'] == 'NO' ? ' NOT NULL' : '')."</td><td class=\"altbg2\">".
						"<font color=\"#0000FF\">$lang[dbcheck_delete]</font></td></tr>";
					$haverepair = TRUE;
				}
				foreach($addlist as $value) {
					echo "<tr><td class=\"altbg1\"><b>".$value['Field']."</b> ".$discuzdbnew[$dbtable][$value['Field']]['Type'].($discuzdbnew[$dbtable][$value['Field']]['Null'] == 'NO' ? ' NOT NULL' : '')."</td><td class=\"altbg2\"><font color=\"#00FF00\">$lang[dbcheck_userfield]</font></tr>";
				}
			}

		}

		if($missingtables) {
			echo "<tr class=\"header\"><td colspan=\"2\">$lang[dbcheck_missing_tables]</td></tr>";
			echo '<tr class="altbg1"><td colspan="2">'.implode(', ', $missingtables).'</td></tr>';
		}

		if($charseterror) {
			echo "<tr class=\"header\"><td colspan=\"2\">$lang[dbcheck_charseterror_tables] ($lang[dbcheck_charseterror_notice] $dbcharset)</td></tr>";
			echo '<tr class="altbg1"><td colspan="2">'.$tablepre.implode(', '.$tablepre, $charseterror).'</td></tr>';
		}

	}

?>
</table>
<?

	if($haverepair) {
		echo "<center><input type=\"submit\" class=\"button\" name=\"repairsubmit\" value=\"$lang[dbcheck_repair]\"></center>";
	}

?>
</form>
<?

} elseif($action == 'ftpcheck') {
	require_once './include/ftp.func.php';
	if(!empty($settingsnew['ftp']['password'])) {
		$query = $db->query("SELECT value FROM {$tablepre}settings WHERE variable='ftp'");
		$settings['ftp'] = unserialize($db->result($query, 0));
		$settings['ftp']['password'] = authcode($settings['ftp']['password'], 'DECODE', md5($authkey));
		$pwlen = strlen($settingsnew['ftp']['password']);
		if($settingsnew['ftp']['password']{0} == $settings['ftp']['password']{0} && $settingsnew['ftp']['password']{$pwlen - 1} == $settings['ftp']['password']{strlen($settings['ftp']['password']) - 1} && substr($settingsnew['ftp']['password'], 1, $pwlen - 2) == '********') {
			$settingsnew['ftp']['password'] = $settings['ftp']['password'];
		}
	}
	$ftp_conn_id = dftp_connect($settingsnew['ftp']['host'], $settingsnew['ftp']['username'], $settingsnew['ftp']['password'], $settingsnew['ftp']['attachdir'], $settingsnew['ftp']['port'], $settingsnew['ftp']['ssl'], 1);
	switch($ftp_conn_id) {
		case '-1':
			$alertmsg = $lang['settings_remote_conerr'];
			break;
		case '-2':
			$alertmsg = $lang['settings_remote_logerr'];
			break;
		case '-3':
			$alertmsg = $lang['settings_remote_pwderr'];
			break;
		default:
			$alertmsg = '';
	}
	if(!$alertmsg) {
		$tmpdir = md5('Discuz!');
		if(!dftp_mkdir($ftp_conn_id, $tmpdir)) {
			$alertmsg = $lang['settings_remote_mderr'];
		} else {
			$tmpfile = $tmpdir.'/test.test';
			if(!dftp_put($ftp_conn_id, $tmpfile, $attachdir.'/index.htm', FTP_BINARY)) {
				$alertmsg = $lang['settings_remote_uperr'];
			} else {
				if(!dftp_delete($ftp_conn_id, $tmpfile)) {
					$alertmsg = $lang['settings_remote_delerr'];
				} else {
					dftp_delete($ftp_conn_id, $tmpdir);
					$alertmsg = $lang['settings_remote_ok'];
				}
			}
		}
	}
	echo '<script language="javascript">alert(\''.addslashes($alertmsg).'\');parent.$(\'settings\').action=\'admincp.php?action=settings&edit=yes\';parent.$(\'settings\').target=\'_self\'</script>';
}

function checkfiles($currentdir, $ext = '', $sub = 1, $skip = '') {
	global $md5data, $savedata;
	$currentdir = $currentdir;
	$dir = opendir($currentdir);
	$exts = '/('.$ext.')$/i';
	$skips = explode(',', $skip);

	while($entry = readdir($dir)) {
		$file = $currentdir.$entry;
		if($entry != '.' && $entry != '..' && (preg_match($exts, $entry) || $sub && is_dir($file)) && !in_array($entry, $skips)) {
			if($sub && is_dir($file)) {
				checkfiles($file.'/', $ext, $sub, $skip);
			} else {
				$md5data[$file] = md5_file($file);
			}
		}
	}
}

function checkcachefiles($currentdir) {
	global $authkey;
	$dir = opendir($currentdir);
	$exts = '/\.php$/i';
	$showlist = $modifylist = $addlist = array();
	while($entry = readdir($dir)) {
		$file = $currentdir.$entry;
		if($entry != '.' && $entry != '..' && preg_match($exts, $entry)) {
			$fp = fopen($file, "rb");
			$cachedata = fread($fp, filesize($file));
			fclose($fp);

			if(preg_match("/^<\?php\n\/\/Discuz! cache file, DO NOT modify me!\n\/\/Created: [\w\s,:]+\n\/\/Identify: (\w{32})\n\n(.+?)\?>$/s", $cachedata, $match)) {
				$showlist[$file] = $md5 = $match[1];
				$cachedata = $match[2];

				if(md5($entry.$cachedata.$authkey) != $md5) {
					$modifylist[$file] = $md5;
				}
			} else {
				$showlist[$file] = $addlist[$file] = '';
			}
		}

	}

	return array($showlist, $modifylist, $addlist);
}

?>